/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.PacketBufferUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.StringTextComponent;

public class BlocklingNameMessage
extends BlocklingMessage<BlocklingNameMessage> {
    @Nonnull
    private String name = "";

    public BlocklingNameMessage() {
        super(null);
    }

    public BlocklingNameMessage(@Nonnull BlocklingEntity blockling, @Nullable StringTextComponent name) {
        super(blockling, false);
        this.name = name == null ? "" : name.getString();
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        PacketBufferUtils.writeString(buf, this.name);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.name = PacketBufferUtils.readString(buf);
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.setCustomName(this.name.equals("") ? null : new StringTextComponent(this.name), false);
    }
}

