/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.network.BlocklingMessage;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class BlocklingTypeMessage
extends BlocklingMessage<BlocklingTypeMessage> {
    private BlocklingType type;
    private boolean natural;

    public BlocklingTypeMessage() {
        super(null);
    }

    public BlocklingTypeMessage(@Nonnull BlocklingEntity blockling, @Nonnull BlocklingType type, boolean natural) {
        super(blockling);
        this.type = type;
        this.natural = natural;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeInt(BlocklingType.TYPES.indexOf(this.type));
        buf.writeBoolean(this.natural);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.type = BlocklingType.TYPES.get(buf.readInt());
        this.natural = buf.readBoolean();
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        if (this.natural) {
            blockling.setNaturalBlocklingType(this.type, false);
        } else {
            blockling.setBlocklingType(this.type, false);
        }
    }
}

