/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class GoalStateMessage
extends BlocklingMessage<GoalStateMessage> {
    private UUID goalId;
    private BlocklingGoal.State state;

    public GoalStateMessage() {
        super(null);
    }

    public GoalStateMessage(@Nonnull BlocklingEntity blockling, @Nonnull UUID goalId, @Nonnull BlocklingGoal.State state) {
        super(blockling);
        this.goalId = goalId;
        this.state = state;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.goalId);
        buf.func_179249_a((Enum)this.state);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.goalId = buf.func_179253_g();
        this.state = (BlocklingGoal.State)buf.func_179257_a(BlocklingGoal.State.class);
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        Objects.requireNonNull(this.goalId);
        Objects.requireNonNull(this.state);
        blockling.getTasks().getTask(this.goalId).getGoal().setState(this.state, false);
    }
}

