/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.network.Message;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetTypeCommandMessage
extends Message {
    private String type;
    private boolean natural;

    public SetTypeCommandMessage(@Nonnull String type, boolean natural) {
        this.type = type;
        this.natural = natural;
    }

    public void encode(@Nonnull PacketBuffer buf) {
        PacketBufferUtils.writeString(buf, this.type);
        buf.writeBoolean(this.natural);
    }

    @Nonnull
    public static SetTypeCommandMessage decode(@Nonnull PacketBuffer buf) {
        return new SetTypeCommandMessage(PacketBufferUtils.readString(buf), buf.readBoolean());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            Entity entity;
            boolean isClient = context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
            PlayerEntity player = isClient ? this.getClientPlayer() : context.getSender();
            Objects.requireNonNull(player, "No player entity found when handling message.");
            if (isClient && (entity = Minecraft.func_71410_x().field_147125_j) instanceof BlocklingEntity) {
                BlocklingEntity blockling = (BlocklingEntity)entity;
                if (this.natural) {
                    blockling.setNaturalBlocklingType(BlocklingType.find(this.type));
                } else {
                    blockling.setBlocklingType(BlocklingType.find(this.type));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

