/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.IntAttribute;
import com.willr27.blocklings.network.Message;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetXpCommandMessage
extends Message {
    private BlocklingAttributes.Level level;
    private int value;

    public SetXpCommandMessage(@Nonnull BlocklingAttributes.Level level, int value) {
        this.level = level;
        this.value = value;
    }

    public void encode(@Nonnull PacketBuffer buf) {
        PacketBufferUtils.writeString(buf, this.level.name());
        buf.writeInt(this.value);
    }

    @Nonnull
    public static SetXpCommandMessage decode(@Nonnull PacketBuffer buf) {
        return new SetXpCommandMessage(BlocklingAttributes.Level.valueOf(PacketBufferUtils.readString(buf)), buf.readInt());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            Entity entity;
            boolean isClient = context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
            PlayerEntity player = isClient ? this.getClientPlayer() : context.getSender();
            Objects.requireNonNull(player, "No player entity found when handling message.");
            if (isClient && (entity = Minecraft.func_71410_x().field_147125_j) instanceof BlocklingEntity) {
                BlocklingEntity blockling = (BlocklingEntity)entity;
                if (this.level == BlocklingAttributes.Level.TOTAL) {
                    for (BlocklingAttributes.Level level : Arrays.stream(BlocklingAttributes.Level.values()).filter(lvl -> lvl != BlocklingAttributes.Level.TOTAL).collect(Collectors.toList())) {
                        ((IntAttribute)blockling.getStats().getLevelXpAttribute(level)).setValue(this.value);
                    }
                } else {
                    ((IntAttribute)blockling.getStats().getLevelXpAttribute(this.level)).setValue(this.value);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

