/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class SkillStateMessage
extends BlocklingMessage<SkillStateMessage> {
    private UUID skillId;
    private UUID groupId;
    private Skill.State state;

    public SkillStateMessage() {
        super(null);
    }

    public SkillStateMessage(@Nonnull BlocklingEntity blockling, @Nonnull Skill skill) {
        super(blockling);
        this.skillId = skill.info.id;
        this.groupId = skill.group.info.id;
        this.state = skill.getState();
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.skillId);
        buf.func_179252_a(this.groupId);
        buf.func_179249_a((Enum)this.state);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.skillId = buf.func_179253_g();
        this.groupId = buf.func_179253_g();
        this.state = (Skill.State)buf.func_179257_a(Skill.State.class);
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.getSkills().getGroup(this.groupId).getSkill(this.skillId).setState(this.state, false);
    }
}

