/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class TaskCustomNameMessage
extends BlocklingMessage<TaskCustomNameMessage> {
    private UUID taskId;
    private String customName;

    public TaskCustomNameMessage() {
        super(null);
    }

    public TaskCustomNameMessage(@Nonnull BlocklingEntity blockling, @Nonnull UUID taskId, @Nonnull String customName) {
        super(blockling);
        this.taskId = taskId;
        this.customName = customName;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.taskId);
        PacketBufferUtils.writeString(buf, this.customName);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.taskId = buf.func_179253_g();
        this.customName = PacketBufferUtils.readString(buf);
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.getTasks().getTask(this.taskId).setCustomName(this.customName, false);
    }
}

