/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class TaskSwapPriorityMessage
extends BlocklingMessage<TaskSwapPriorityMessage> {
    private UUID taskId1;
    private UUID taskId2;

    public TaskSwapPriorityMessage() {
        super(null);
    }

    public TaskSwapPriorityMessage(@Nonnull BlocklingEntity blockling, @Nonnull UUID taskId1, @Nonnull UUID taskId2) {
        super(blockling);
        this.taskId1 = taskId1;
        this.taskId2 = taskId2;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.taskId1);
        buf.func_179252_a(this.taskId2);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.taskId1 = buf.func_179253_g();
        this.taskId2 = buf.func_179253_g();
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        Task task1 = blockling.getTasks().getTask(this.taskId1);
        Task task2 = blockling.getTasks().getTask(this.taskId2);
        task1.swapPriority(task2, false);
    }
}

