/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.TaskType;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class TaskTypeIsUnlockedMessage
extends BlocklingMessage<TaskTypeIsUnlockedMessage> {
    private UUID taskInfoId;
    private boolean isUnlocked;

    public TaskTypeIsUnlockedMessage() {
        super(null);
    }

    public TaskTypeIsUnlockedMessage(@Nonnull BlocklingEntity blockling, @Nonnull TaskType taskInfo, boolean isUnlocked) {
        super(blockling);
        this.taskInfoId = taskInfo.id;
        this.isUnlocked = isUnlocked;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.taskInfoId);
        buf.writeBoolean(this.isUnlocked);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.taskInfoId = buf.func_179253_g();
        this.isUnlocked = buf.readBoolean();
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.getTasks().setIsUnlocked(BlocklingTasks.getTaskType(this.taskInfoId), this.isUnlocked, false);
    }
}

