/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class WhitelistAllMessage
extends BlocklingMessage<WhitelistAllMessage> {
    private UUID taskId;
    private int whitelistId;
    private Whitelist<ResourceLocation> whitelist;

    public WhitelistAllMessage() {
        super(null);
    }

    public WhitelistAllMessage(@Nonnull BlocklingEntity blockling, @Nonnull UUID taskId, int whitelistId, @Nonnull GoalWhitelist whitelist) {
        super(blockling);
        this.taskId = taskId;
        this.whitelistId = whitelistId;
        this.whitelist = whitelist;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.taskId);
        buf.writeInt(this.whitelistId);
        buf.writeInt(this.whitelist.size());
        for (ResourceLocation entry : this.whitelist.keySet()) {
            PacketBufferUtils.writeString(buf, entry.toString());
            buf.writeBoolean(((Boolean)this.whitelist.get(entry)).booleanValue());
        }
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.taskId = buf.func_179253_g();
        this.whitelistId = buf.readInt();
        this.whitelist = new Whitelist();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.whitelist.put(new ResourceLocation(PacketBufferUtils.readString(buf)), buf.readBoolean());
        }
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.getTasks().getTask((UUID)this.taskId).getGoal().whitelists.get(this.whitelistId).setWhitelist(this.whitelist, false);
    }
}

