/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network.messages;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class WhitelistSingleMessage
extends BlocklingMessage<WhitelistSingleMessage> {
    private UUID taskId;
    private int whitelistId;
    private ResourceLocation entry;
    private boolean value;

    public WhitelistSingleMessage() {
        super(null);
    }

    public WhitelistSingleMessage(@Nonnull BlocklingEntity blockling, @Nonnull UUID taskId, int whitelistId, @Nonnull ResourceLocation entry, boolean value) {
        super(blockling);
        this.taskId = taskId;
        this.whitelistId = whitelistId;
        this.entry = entry;
        this.value = value;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.func_179252_a(this.taskId);
        buf.writeInt(this.whitelistId);
        PacketBufferUtils.writeString(buf, this.entry.toString());
        buf.writeBoolean(this.value);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.taskId = buf.func_179253_g();
        this.whitelistId = buf.readInt();
        this.entry = new ResourceLocation(PacketBufferUtils.readString(buf));
        this.value = buf.readBoolean();
    }

    @Override
    protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
        blockling.getTasks().getTask((UUID)this.taskId).getGoal().whitelists.get(this.whitelistId).setEntry(this.entry, this.value, false);
    }
}

