/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.config.BlocklingsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;

public class BlockUtil {
    @Nonnull
    public static Lazy<Set<Block>> ORES = Lazy.of(BlockUtil::createOresList);
    @Nonnull
    public static Lazy<List<TreeTuple>> TREES = Lazy.of(BlockUtil::createTreesList);
    @Nonnull
    public static Lazy<Set<Block>> CROPS = Lazy.of(BlockUtil::createCropsList);

    @Nonnull
    public static Set<Block> createOresList() {
        Blocklings.LOGGER.info("Creating ores list.");
        HashSet<Block> ores = new HashSet<Block>();
        List additionalBlocks = (List)BlocklingsConfig.COMMON.additionalOres.get();
        List excludedBlocks = (List)BlocklingsConfig.COMMON.excludedOres.get();
        ores.clear();
        for (Block block : Tags.Blocks.ORES.func_230236_b_()) {
            if (excludedBlocks.contains(block.getRegistryName().toString())) continue;
            ores.add(block);
        }
        for (String entry : additionalBlocks) {
            Runnable warn = () -> Blocklings.LOGGER.warn("Skipping additional ore \"" + entry + "\".");
            Block block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(entry));
            if (block.func_235332_a_(Blocks.field_150350_a)) {
                warn.run();
                continue;
            }
            if (excludedBlocks.contains(entry)) {
                warn.run();
                continue;
            }
            ores.add(block);
        }
        return ores;
    }

    public static boolean isOre(@Nonnull Block block) {
        return ((Set)ORES.get()).contains(block);
    }

    public static boolean isOre(@Nonnull Item blockItem) {
        return BlockUtil.getOre(blockItem) != null;
    }

    @Nullable
    public static Block getOre(@Nonnull Item blockItem) {
        for (Block ore : (Set)ORES.get()) {
            if (new ItemStack((IItemProvider)ore).func_77973_b() != blockItem) continue;
            return ore;
        }
        return null;
    }

    @Nonnull
    public static List<TreeTuple> createTreesList() {
        Blocklings.LOGGER.info("Creating trees list.");
        ArrayList<TreeTuple> trees = new ArrayList<TreeTuple>();
        List customTrees = (List)BlocklingsConfig.COMMON.customTrees.get();
        trees.clear();
        trees.add(new TreeTuple(Blocks.field_196621_O, Blocks.field_196572_aa, Blocks.field_196679_x));
        trees.add(new TreeTuple(Blocks.field_196619_M, Blocks.field_196647_Y, Blocks.field_196676_v));
        trees.add(new TreeTuple(Blocks.field_196623_P, Blocks.field_196574_ab, Blocks.field_196680_y));
        trees.add(new TreeTuple(Blocks.field_196620_N, Blocks.field_196648_Z, Blocks.field_196678_w));
        trees.add(new TreeTuple(Blocks.field_196617_K, Blocks.field_196642_W, Blocks.field_196674_t));
        trees.add(new TreeTuple(Blocks.field_196618_L, Blocks.field_196645_X, Blocks.field_196675_u));
        for (String treeString : customTrees) {
            Runnable warn = () -> Blocklings.LOGGER.warn("The custom tree \"" + treeString + "\" is invalid and won't be added. Should look like \"[minecraft:oak_log; minecraft:oak_leaf; minecraft:oak_sapling]\".");
            if (!treeString.startsWith("[") || !treeString.endsWith("]") || treeString.length() < 10) {
                warn.run();
                continue;
            }
            String[] splitTreeString = treeString.substring(1, treeString.length() - 1).split("; ");
            if (splitTreeString.length != 3) {
                warn.run();
                continue;
            }
            Block log = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(splitTreeString[0]));
            Block leaves = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(splitTreeString[1]));
            Block sapling = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(splitTreeString[2]));
            if (log.func_235332_a_(Blocks.field_150350_a) || leaves.func_235332_a_(Blocks.field_150350_a) || sapling.func_235332_a_(Blocks.field_150350_a)) {
                warn.run();
                continue;
            }
            TreeTuple tree = new TreeTuple(log, leaves, sapling);
            if (trees.contains(tree)) continue;
            trees.add(tree);
        }
        return trees;
    }

    public static boolean isLog(@Nonnull Block block) {
        return ((List)TREES.get()).stream().anyMatch(tree -> tree.log == block);
    }

    public static boolean isLog(@Nonnull Item blockItem) {
        return BlockUtil.getLog(blockItem) != null;
    }

    @Nullable
    public static Block getLog(@Nonnull Item blockItem) {
        for (TreeTuple tree : (List)TREES.get()) {
            if (new ItemStack((IItemProvider)tree.log).func_77973_b() != blockItem) continue;
            return tree.log;
        }
        return null;
    }

    public static boolean isLeaves(@Nonnull Block block) {
        return ((List)TREES.get()).stream().anyMatch(tree -> tree.leaves == block);
    }

    public static boolean isLeaves(@Nonnull Item blockItem) {
        return BlockUtil.getLeaves(blockItem) != null;
    }

    @Nullable
    public static Block getLeaves(@Nonnull Block logBlock) {
        for (TreeTuple tree : (List)TREES.get()) {
            if (tree.log != logBlock) continue;
            return tree.leaves;
        }
        return null;
    }

    @Nullable
    public static Block getLeaves(@Nonnull Item blockItem) {
        for (TreeTuple tree : (List)TREES.get()) {
            if (new ItemStack((IItemProvider)tree.leaves).func_77973_b() != blockItem) continue;
            return tree.leaves;
        }
        return null;
    }

    public static boolean isSapling(@Nonnull Block block) {
        return ((List)TREES.get()).stream().anyMatch(tree -> tree.sapling == block);
    }

    public static boolean isSapling(@Nonnull Item blockItem) {
        return BlockUtil.getSapling(blockItem) != null;
    }

    @Nullable
    public static Block getSapling(@Nonnull Item blockItem) {
        for (TreeTuple tree : (List)TREES.get()) {
            if (new ItemStack((IItemProvider)tree.sapling).func_77973_b() != blockItem) continue;
            return tree.sapling;
        }
        return null;
    }

    @Nullable
    public static Block getSaplingFromLog(@Nonnull Block logBlock) {
        for (TreeTuple tree : (List)TREES.get()) {
            if (tree.log != logBlock) continue;
            return tree.sapling;
        }
        return null;
    }

    @Nonnull
    public static Set<Block> createCropsList() {
        Blocklings.LOGGER.info("Creating crops list.");
        HashSet<Block> crops = new HashSet<Block>();
        crops.clear();
        crops.add(Blocks.field_150464_aj);
        crops.add(Blocks.field_185773_cZ);
        crops.add(Blocks.field_150459_bM);
        crops.add(Blocks.field_150469_bN);
        crops.add(Blocks.field_150423_aK);
        crops.add(Blocks.field_150440_ba);
        for (String additionalString : (List)BlocklingsConfig.COMMON.additionalCrops.get()) {
            Runnable warn = () -> Blocklings.LOGGER.warn("Skipping additional crop \"" + additionalString + "\".");
            Block block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(additionalString));
            if (block.func_235332_a_(Blocks.field_150350_a)) {
                warn.run();
                continue;
            }
            crops.add(block);
        }
        for (String excludedString : (List)BlocklingsConfig.COMMON.excludedCrops.get()) {
            crops.remove(Registry.field_212618_g.func_82594_a(new ResourceLocation(excludedString)));
        }
        return crops;
    }

    public static boolean isCrop(@Nonnull Block block) {
        return ((Set)CROPS.get()).contains(block);
    }

    public static boolean isCrop(@Nonnull Item blockItem) {
        return BlockUtil.getCrop(blockItem) != null;
    }

    @Nullable
    public static Block getCrop(@Nonnull Item blockItem) {
        for (Block crop : (Set)CROPS.get()) {
            if (new ItemStack((IItemProvider)crop).func_77973_b() != blockItem) continue;
            return crop;
        }
        return null;
    }

    public static boolean canPlaceAt(@Nonnull World world, @Nonnull Block block, @Nonnull BlockPos pos) {
        return block.func_196260_a(block.func_176223_P(), (IWorldReader)world, pos);
    }

    public static int calcBlockBreakProgress(float percentage) {
        return (int)(10.0f * percentage);
    }

    public static boolean areAllAdjacentBlocksSolid(@Nonnull World world, @Nonnull BlockPos blockPos) {
        return !Arrays.stream(BlockUtil.getAdjacentBlockPositions(blockPos)).anyMatch(blockPos1 -> !world.func_180495_p(blockPos1).func_185904_a().func_76220_a());
    }

    @Nonnull
    public static BlockPos[] getAdjacentBlockPositions(@Nonnull BlockPos blockPos) {
        return new BlockPos[]{blockPos.func_177982_a(-1, 0, 0), blockPos.func_177982_a(1, 0, 0), blockPos.func_177982_a(0, -1, 0), blockPos.func_177982_a(0, 1, 0), blockPos.func_177982_a(0, 0, -1), blockPos.func_177982_a(0, 0, 1)};
    }

    @Nonnull
    public static BlockPos[] getSurroundingBlockPositions(@Nonnull BlockPos blockPos) {
        return new BlockPos[]{blockPos.func_177982_a(-1, 0, -1), blockPos.func_177982_a(-1, 0, 0), blockPos.func_177982_a(-1, 0, 1), blockPos.func_177982_a(0, 0, -1), blockPos.func_177982_a(0, 0, 1), blockPos.func_177982_a(1, 0, -1), blockPos.func_177982_a(1, 0, 0), blockPos.func_177982_a(1, 0, 1), blockPos.func_177982_a(-1, -1, -1), blockPos.func_177982_a(-1, -1, 0), blockPos.func_177982_a(-1, -1, 1), blockPos.func_177982_a(0, -1, -1), blockPos.func_177982_a(0, -1, 0), blockPos.func_177982_a(0, -1, 1), blockPos.func_177982_a(1, -1, -1), blockPos.func_177982_a(1, -1, 0), blockPos.func_177982_a(1, -1, 1), blockPos.func_177982_a(0, 1, -1), blockPos.func_177982_a(0, 1, 0), blockPos.func_177982_a(0, 1, 1), blockPos.func_177982_a(-1, 1, -1), blockPos.func_177982_a(-1, 1, 0), blockPos.func_177982_a(-1, 1, 1), blockPos.func_177982_a(1, 1, -1), blockPos.func_177982_a(1, 1, 0), blockPos.func_177982_a(1, 1, 1)};
    }

    public static double distanceSq(@Nonnull BlockPos blockPos1, @Nonnull BlockPos blockPos2) {
        return blockPos1.func_218140_a((double)blockPos2.func_177958_n(), (double)blockPos2.func_177956_o(), (double)blockPos2.func_177952_p(), false);
    }

    public static class TreeTuple {
        @Nonnull
        public final Block log;
        @Nonnull
        public final Block leaves;
        @Nonnull
        public final Block sapling;

        public TreeTuple(@Nonnull Block log, @Nonnull Block leaves, @Nonnull Block sapling) {
            this.log = log;
            this.leaves = leaves;
            this.sapling = sapling;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TreeTuple) {
                TreeTuple tree = (TreeTuple)obj;
                return tree.log == this.log && tree.leaves == this.leaves && tree.sapling == this.sapling;
            }
            return super.equals(obj);
        }
    }
}

