/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.skill.skills.MiningSkills;
import com.willr27.blocklings.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DropUtil {
    @Nonnull
    public static List<ItemStack> getDrops(@Nonnull Context context, @Nonnull BlocklingEntity blockling, @Nonnull BlockPos blockPos, @Nonnull ItemStack mainStack, @Nonnull ItemStack offStack) {
        World world = blockling.field_70170_p;
        ItemStack mergedStack = mainStack.func_77946_l();
        for (Enchantment enchantment : ToolUtil.findToolEnchantments(offStack)) {
            int mainLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)mainStack);
            int offLevel = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)offStack);
            mergedStack.func_77966_a(enchantment, Math.max(mainLevel, offLevel));
        }
        if (blockling.getNaturalBlocklingType() == BlocklingType.LAPIS || blockling.getBlocklingType() == BlocklingType.LAPIS) {
            mergedStack.func_77966_a(Enchantments.field_185308_t, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)mergedStack) + 1);
        }
        ArrayList<ItemStack> drops = Block.func_220077_a((BlockState)world.func_180495_p(blockPos), (ServerWorld)((ServerWorld)world), (BlockPos)blockPos, null, null, (ItemStack)mergedStack);
        if (context == Context.MINING && blockling.getSkills().getSkill(MiningSkills.HOT_HANDS).isBought()) {
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            for (ItemStack stack : drops) {
                Optional recipeFor = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), world);
                if (recipeFor.isPresent()) {
                    newDrops.add(((FurnaceRecipe)recipeFor.get()).func_77571_b().func_77946_l());
                    continue;
                }
                newDrops.add(stack);
            }
            drops = newDrops;
        }
        return drops;
    }

    public static enum Context {
        MINING,
        WOODCUTTING,
        FARMING;

    }
}

