/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.util.BlockUtil;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;

public class EntityUtil {
    @Nullable
    public static World latestWorld;
    @Nonnull
    public static final Lazy<Map<ResourceLocation, Entity>> VALID_ATTACK_TARGETS;

    @Nonnull
    public static Map<ResourceLocation, Entity> createValidAttackTargetsMap() {
        Blocklings.LOGGER.info("Creating valid attack targets map.");
        if (latestWorld == null) {
            Blocklings.LOGGER.error("Tried to initialise valid attack targets list before a world was loaded!");
            return new TreeMap<ResourceLocation, Entity>();
        }
        TreeMap<ResourceLocation, Entity> validAttackTargets = new TreeMap<ResourceLocation, Entity>();
        for (ResourceLocation entry : Registry.field_212629_r.func_148742_b()) {
            Entity entity = ((EntityType)Registry.field_212629_r.func_82594_a(entry)).func_200721_a(latestWorld);
            if (entity != null) {
                if (!EntityUtil.isValidAttackTarget(entity)) continue;
                validAttackTargets.put(entry, entity);
                continue;
            }
            Blocklings.LOGGER.warn("Failed to create entity: " + entry);
        }
        return validAttackTargets;
    }

    @Nonnull
    public static Entity create(@Nonnull ResourceLocation type, @Nonnull World world) {
        return Objects.requireNonNull(((EntityType)Registry.field_212629_r.func_82594_a(type)).func_200721_a(world));
    }

    public static boolean isValidAttackTarget(@Nonnull Entity entity) {
        if (!(entity instanceof MobEntity)) {
            return false;
        }
        if (entity instanceof FlyingEntity) {
            return false;
        }
        return !(entity instanceof WaterMobEntity);
    }

    public static boolean canSee(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos) {
        Vector3d entityPos = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        for (double x = 0.05; x < 1.0; x += 0.9) {
            for (double y = 0.05; y < 1.0; y += 0.9) {
                for (double z = 0.05; z < 1.0; z += 0.9) {
                    Vector3d targetPos = new Vector3d((double)blockPos.func_177958_n() + x, (double)blockPos.func_177956_o() + y, (double)blockPos.func_177952_p() + z);
                    BlockRayTraceResult result = entity.field_70170_p.func_217299_a(new RayTraceContext(entityPos, targetPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)entity));
                    if (result.func_216346_c() == RayTraceResult.Type.MISS || !result.func_216350_a().equals((Object)blockPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInRange(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos, float rangeSq) {
        return (float)BlockUtil.distanceSq(entity.func_233580_cy_(), blockPos) < rangeSq;
    }

    @Nullable
    public static Path createPathTo(@Nonnull MobEntity entity, @Nonnull BlockPos blockPos) {
        return EntityUtil.createPathTo(entity, blockPos, 0.0f);
    }

    @Nullable
    public static Path createPathTo(@Nonnull MobEntity entity, @Nonnull BlockPos blockPos, float stopDistanceSq) {
        Path closestPath = null;
        double closestDistanceSq = Double.MAX_VALUE;
        Path path = entity.func_70661_as().func_179680_a(blockPos, 0);
        if (path != null) {
            closestPath = path;
            closestDistanceSq = BlockUtil.distanceSq(blockPos, path.func_224770_k());
            if (!path.func_224770_k().equals((Object)blockPos.func_177984_a()) && closestDistanceSq < (double)stopDistanceSq) {
                return closestPath;
            }
            if (stopDistanceSq != 0.0f) {
                closestDistanceSq = stopDistanceSq;
            }
        }
        for (BlockPos adjacentPos : BlockUtil.getSurroundingBlockPositions(blockPos)) {
            double distanceSq;
            path = entity.func_70661_as().func_179680_a(adjacentPos, 0);
            if (path == null || !((distanceSq = BlockUtil.distanceSq(blockPos, path.func_224770_k())) < closestDistanceSq)) continue;
            closestPath = path;
            closestDistanceSq = distanceSq;
            if (!(closestDistanceSq < (double)stopDistanceSq)) continue;
            return closestPath;
        }
        return stopDistanceSq > 0.0f ? null : closestPath;
    }

    static {
        VALID_ATTACK_TARGETS = Lazy.of(EntityUtil::createValidAttackTargetsMap);
    }
}

