/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.willr27.blocklings.util.ToolUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum ToolType {
    WEAPON,
    PICKAXE,
    AXE,
    HOE;


    public boolean is(ItemStack stack) {
        return ToolType.isTooltype(this, stack.func_77973_b());
    }

    public boolean is(Item item) {
        return ToolType.isTooltype(this, item);
    }

    public static boolean isTooltype(ToolType type, Item item) {
        switch (type) {
            case WEAPON: {
                return ToolUtil.isWeapon(item);
            }
            case PICKAXE: {
                return ToolUtil.isPickaxe(item);
            }
            case AXE: {
                return ToolUtil.isAxe(item);
            }
            case HOE: {
                return ToolUtil.isHoe(item);
            }
        }
        return false;
    }

    public static ToolType getToolType(ItemStack stack) {
        return ToolType.getToolType(stack.func_77973_b());
    }

    public static ToolType getToolType(Item item) {
        for (ToolType type : ToolType.values()) {
            if (!ToolType.isTooltype(type, item)) continue;
            return type;
        }
        return null;
    }
}

