/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.google.common.collect.Multimap;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.interop.TinkersConstructProxy;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.ToolContext;
import com.willr27.blocklings.util.ToolType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ToolUtil {
    private static final List<Item> WEAPONS = new ArrayList<Item>();
    private static final List<Item> PICKAXES = new ArrayList<Item>();
    private static final List<Item> AXES = new ArrayList<Item>();
    private static final List<Item> HOES = new ArrayList<Item>();
    private static final List<Item> TOOLS = new ArrayList<Item>();

    public static void init() {
        WEAPONS.clear();
        PICKAXES.clear();
        AXES.clear();
        HOES.clear();
        WEAPONS.addAll(ToolUtil.findAllWeapons());
        PICKAXES.addAll(Registry.field_212630_s.func_201756_e().filter(item -> item.getToolTypes(item.func_190903_i()).contains(net.minecraftforge.common.ToolType.PICKAXE)).collect(Collectors.toList()));
        AXES.addAll(Registry.field_212630_s.func_201756_e().filter(item -> item.getToolTypes(item.func_190903_i()).contains(net.minecraftforge.common.ToolType.AXE)).collect(Collectors.toList()));
        HOES.addAll(Registry.field_212630_s.func_201756_e().filter(item -> item.getToolTypes(item.func_190903_i()).contains(net.minecraftforge.common.ToolType.HOE)).collect(Collectors.toList()));
        TOOLS.addAll(WEAPONS);
        TOOLS.addAll(PICKAXES);
        TOOLS.addAll(AXES);
        TOOLS.addAll(HOES);
    }

    @Nonnull
    private static List<Item> findAllWeapons() {
        List<Item> weapons = Registry.field_212630_s.func_201756_e().filter(item -> item instanceof SwordItem).collect(Collectors.toList());
        weapons.addAll(TinkersConstructProxy.instance.findAllWeapons());
        return weapons;
    }

    public static boolean isWeapon(@Nonnull ItemStack stack) {
        return ToolUtil.isWeapon(stack.func_77973_b());
    }

    public static boolean isWeapon(@Nonnull Item item) {
        return WEAPONS.contains(item);
    }

    public static boolean isPickaxe(@Nonnull ItemStack stack) {
        return ToolUtil.isPickaxe(stack.func_77973_b());
    }

    public static boolean isPickaxe(@Nonnull Item item) {
        return PICKAXES.contains(item);
    }

    public static boolean isAxe(@Nonnull ItemStack stack) {
        return ToolUtil.isAxe(stack.func_77973_b());
    }

    public static boolean isAxe(@Nonnull Item item) {
        return AXES.contains(item);
    }

    public static boolean isHoe(@Nonnull ItemStack stack) {
        return ToolUtil.isHoe(stack.func_77973_b());
    }

    public static boolean isHoe(@Nonnull Item item) {
        return HOES.contains(item);
    }

    public static boolean isTool(@Nonnull ItemStack stack) {
        return ToolUtil.isTool(stack.func_77973_b());
    }

    public static boolean isTool(@Nonnull Item item) {
        return TOOLS.contains(item);
    }

    public static boolean isTinkersTool(@Nonnull ItemStack stack) {
        return ToolUtil.isTinkersTool(stack.func_77973_b());
    }

    public static boolean isTinkersTool(@Nonnull Item item) {
        return TinkersConstructProxy.instance.isTinkersTool(item);
    }

    public static boolean isUseableTool(@Nonnull ItemStack stack) {
        if (!ToolUtil.isTool(stack)) {
            return false;
        }
        if (ToolUtil.isTinkersTool(stack)) {
            return TinkersConstructProxy.instance.isToolBroken(stack);
        }
        return true;
    }

    public static float getDefaultToolAttackSpeed(@Nonnull ItemStack stack) {
        return ToolUtil.getToolAttackSpeed(stack, null);
    }

    public static float getToolAttackSpeed(@Nonnull ItemStack stack, @Nullable LivingEntity entity) {
        if (ToolUtil.isUseableTool(stack)) {
            Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                UUID baseAttackSpeedAttributeId = (UUID)ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)Items.field_185153_aK, (String)"field_185050_h");
                if (attributemodifier.func_111167_a() != baseAttackSpeedAttributeId) continue;
                return (float)attributemodifier.func_111164_d() + 4.0f;
            }
        }
        return 4.0f;
    }

    public static float getDefaultToolBaseDamage(@Nonnull ItemStack stack) {
        return ToolUtil.getToolBaseDamage(stack, null);
    }

    public static float getToolBaseDamage(@Nonnull ItemStack stack, @Nonnull LivingEntity entity) {
        if (ToolUtil.isUseableTool(stack)) {
            Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                UUID baseAttackDamageAttributeId = (UUID)ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)Items.field_185153_aK, (String)"field_111210_e");
                if (attributemodifier.func_111167_a() != baseAttackDamageAttributeId) continue;
                return (float)attributemodifier.func_111164_d();
            }
        }
        return 0.0f;
    }

    public static float getToolEnchantmentDamage(@Nonnull ItemStack stack, @Nonnull CreatureAttribute creatureAttribute) {
        return EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)creatureAttribute);
    }

    public static float getToolKnockbackLevel(@Nonnull ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack);
    }

    public static float getToolFireAspectLevel(@Nonnull ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
    }

    public static float getDefaultToolMiningSpeedWithEnchantments(@Nonnull ItemStack stack) {
        return ToolUtil.getDefaultToolMiningSpeed(stack) + ToolUtil.getToolEnchantmentHarvestSpeed(stack);
    }

    public static float getDefaultToolWoodcuttingSpeedWithEnchantments(@Nonnull ItemStack stack) {
        return ToolUtil.getDefaultToolWoodcuttingSpeed(stack) + ToolUtil.getToolEnchantmentHarvestSpeed(stack);
    }

    public static float getDefaultToolFarmingSpeedWithEnchantments(@Nonnull ItemStack stack) {
        return ToolUtil.getDefaultToolFarmingSpeed(stack) + ToolUtil.getToolEnchantmentHarvestSpeed(stack);
    }

    public static float getToolHarvestSpeedWithEnchantments(@Nonnull ItemStack stack, @Nonnull BlockState blockState) {
        return ToolUtil.getToolHarvestSpeed(stack, blockState) + ToolUtil.getToolEnchantmentHarvestSpeed(stack);
    }

    public static float getDefaultToolMiningSpeed(@Nonnull ItemStack stack) {
        return ToolUtil.getToolHarvestSpeed(stack, Blocks.field_150348_b.func_176223_P());
    }

    public static float getDefaultToolWoodcuttingSpeed(@Nonnull ItemStack stack) {
        return ToolUtil.getToolHarvestSpeed(stack, Blocks.field_196617_K.func_176223_P());
    }

    public static float getDefaultToolFarmingSpeed(@Nonnull ItemStack stack) {
        return ToolUtil.getToolHarvestSpeed(stack, Blocks.field_150407_cf.func_176223_P());
    }

    public static float getToolHarvestSpeed(@Nonnull ItemStack stack, @Nonnull BlockState blockState) {
        if (ToolUtil.isUseableTool(stack)) {
            if (ToolUtil.isTinkersTool(stack)) {
                if (ToolUtil.canToolHarvest(stack, blockState)) {
                    return TinkersConstructProxy.instance.getToolHarvestSpeed(stack, blockState);
                }
            } else {
                return stack.func_150997_a(blockState);
            }
        }
        return 0.0f;
    }

    public static float getDefaultToolSpeed(@Nonnull ItemStack stack, @Nonnull ToolType toolType) {
        switch (toolType) {
            case WEAPON: {
                return ToolUtil.getDefaultToolAttackSpeed(stack);
            }
            case PICKAXE: {
                return ToolUtil.getDefaultToolMiningSpeed(stack);
            }
            case AXE: {
                return ToolUtil.getDefaultToolWoodcuttingSpeed(stack);
            }
            case HOE: {
                return ToolUtil.getDefaultToolFarmingSpeed(stack);
            }
        }
        return 0.0f;
    }

    public static float getToolHarvestSpeed(@Nonnull ItemStack stack, @Nonnull ToolContext context) {
        switch (context.toolType) {
            case WEAPON: {
                return ToolUtil.getToolAttackSpeed(stack, context.entity);
            }
            case PICKAXE: 
            case AXE: 
            case HOE: {
                return ToolUtil.getToolHarvestSpeed(stack, context.blockState);
            }
        }
        return 0.0f;
    }

    public static float getToolEnchantmentHarvestSpeed(@Nonnull ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        if (level > 0) {
            return (float)(level * level) + 1.0f;
        }
        return 0.0f;
    }

    public static boolean canToolHarvest(@Nonnull ItemStack stack, @Nonnull BlockState blockState) {
        if (BlockUtil.isCrop(blockState.func_177230_c()) && ToolUtil.isHoe(stack)) {
            return true;
        }
        if (BlockUtil.isOre(blockState.func_177230_c()) && !ToolUtil.isPickaxe(stack)) {
            return false;
        }
        if (BlockUtil.isLog(blockState.func_177230_c()) && !ToolUtil.isAxe(stack)) {
            return false;
        }
        if (ToolUtil.isTinkersTool(stack)) {
            return TinkersConstructProxy.instance.canToolHarvest(stack, blockState);
        }
        net.minecraftforge.common.ToolType harvestTool = blockState.getHarvestTool();
        if (harvestTool == null) {
            return true;
        }
        for (net.minecraftforge.common.ToolType toolType : stack.getToolTypes()) {
            if (toolType != harvestTool || stack.getHarvestLevel(toolType, null, blockState) < blockState.getHarvestLevel()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static List<Enchantment> findToolEnchantments(@Nonnull ItemStack stack) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        ListNBT listNBT = stack.func_77986_q();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT tag = listNBT.func_150305_b(i);
            ResourceLocation enchantmentResource = ResourceLocation.func_208304_a((String)tag.func_74779_i("id"));
            if (enchantmentResource == null) continue;
            enchantments.add((Enchantment)Registry.field_212628_q.func_82594_a(enchantmentResource));
        }
        return enchantments;
    }

    public static boolean damageTool(@Nonnull ItemStack stack, @Nonnull BlocklingEntity blockling, int damage) {
        ItemStack copiedStack = stack.func_77946_l();
        if (blockling.getNaturalBlocklingType() == BlocklingType.DIAMOND || blockling.getBlocklingType() == BlocklingType.DIAMOND) {
            copiedStack.func_77966_a(Enchantments.field_185307_s, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)copiedStack) + 1);
        }
        boolean destroyed = copiedStack.func_96631_a(damage, blockling.func_70681_au(), null);
        stack.func_196085_b(copiedStack.func_77952_i());
        return destroyed;
    }
}

