/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import javax.annotation.Nonnull;

public class Version {
    @Nonnull
    private String versionString;

    public Version(@Nonnull String versionString) {
        this.versionString = versionString;
    }

    public boolean isValidVersion(@Nonnull String versionString) {
        String[] splitVersionString = versionString.split("\\.");
        if (splitVersionString.length < 1 || splitVersionString.length > 4) {
            return false;
        }
        for (String subVersionString : splitVersionString) {
            if (subVersionString.matches("[0-9]+")) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version version = (Version)obj;
            if (this.getMajor() == version.getMajor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor()) {
                return true;
            }
            if (this.getPatch() == version.getPatch()) {
                return true;
            }
            if (this.getBuild() == version.getBuild()) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public boolean isOlderThan(@Nonnull Version version) {
        if (this.getMajor() < version.getMajor()) {
            return true;
        }
        if (this.getMinor() < version.getMinor()) {
            return true;
        }
        if (this.getPatch() < version.getPatch()) {
            return true;
        }
        return this.getBuild() < version.getBuild();
    }

    public boolean isNewerThan(@Nonnull Version version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMinor() > version.getMinor()) {
            return true;
        }
        if (this.getPatch() > version.getPatch()) {
            return true;
        }
        return this.getBuild() > version.getBuild();
    }

    public int getMajor() {
        return Integer.parseInt(this.versionString.split("\\.")[0]);
    }

    public int getMinor() {
        String[] splitVersionString = this.versionString.split("\\.");
        if (splitVersionString.length < 2) {
            return 0;
        }
        return Integer.parseInt(splitVersionString[1]);
    }

    public int getPatch() {
        String[] splitVersionString = this.versionString.split("\\.");
        if (splitVersionString.length < 3) {
            return 0;
        }
        return Integer.parseInt(splitVersionString[2]);
    }

    public int getBuild() {
        String[] splitVersionString = this.versionString.split("\\.");
        if (splitVersionString.length < 4) {
            return 0;
        }
        return Integer.parseInt(splitVersionString[3]);
    }

    public String toString() {
        return this.versionString;
    }

    public void setVersion(@Nonnull String versionString) throws IllegalArgumentException {
        if (!this.isValidVersion(versionString)) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        this.versionString = versionString;
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }
}

