/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util;

import com.willr27.blocklings.util.BlockUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldUtil {
    public static final float MAX_LOGS_TO_LEAVES_RATIO = 1.0f;

    @Nonnull
    public static Tree findTreeFromPos(@Nonnull World world, @Nonnull BlockPos blockPos, int maxTreeLogsSize, @Nonnull Predicate<BlockPos> isValidLogPos, @Nonnull Predicate<BlockPos> isValidLeavesPos) {
        Tree tree = new Tree();
        Block logBlock = world.func_180495_p(blockPos).func_177230_c();
        if (!BlockUtil.isLog(logBlock)) {
            return tree;
        }
        Block leavesBlock = BlockUtil.getLeaves(logBlock);
        HashSet<BlockPos> logBlockPositionsToTest = new HashSet<BlockPos>();
        logBlockPositionsToTest.add(blockPos);
        tree.logs.add(blockPos);
        while (!logBlockPositionsToTest.isEmpty() && tree.logs.size() < maxTreeLogsSize) {
            BlockPos testBlockPos = (BlockPos)logBlockPositionsToTest.stream().findFirst().get();
            for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(testBlockPos)) {
                Block surroundingLogBlock = world.func_180495_p(surroundingPos).func_177230_c();
                if (surroundingLogBlock == logBlock && isValidLogPos.test(surroundingPos)) {
                    if (tree.logs.contains(surroundingPos)) continue;
                    tree.logs.add(surroundingPos);
                    logBlockPositionsToTest.add(surroundingPos);
                    continue;
                }
                if (surroundingLogBlock != leavesBlock || !isValidLeavesPos.test(surroundingPos) || tree.leaves.contains(surroundingPos)) continue;
                tree.leaves.add(surroundingPos);
            }
            logBlockPositionsToTest.remove(testBlockPos);
        }
        return tree;
    }

    public static class Tree {
        public final List<BlockPos> logs = new ArrayList<BlockPos>();
        public final List<BlockPos> leaves = new ArrayList<BlockPos>();

        public boolean isValid() {
            return this.leaves.size() != 0 && (float)this.logs.size() / (float)this.leaves.size() <= 1.0f;
        }
    }
}

