/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.util.event;

import com.willr27.blocklings.util.event.Event;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class EventHandler<T extends Event> {
    private final List<Handler<T>> handlers = new ArrayList<Handler<T>>();

    public void handle(@Nonnull T event) {
        for (Handler<T> handler : this.handlers) {
            handler.handle(event);
            if (!((Event)event).isHandled()) continue;
            return;
        }
    }

    public void subscribe(@Nonnull Handler<T> handler) {
        this.handlers.add(handler);
    }

    public void unsubscribe(@Nonnull Handler<T> handler) {
        this.handlers.remove(handler);
    }

    @FunctionalInterface
    public static interface Handler<T extends Event> {
        public void handle(@Nonnull T var1);
    }
}

