/*
 * Decompiled with CFR 0.152.
 */
package mods.alice.cubicvillager.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.alice.cubicvillager.CubicVillager;
import mods.alice.cubicvillager.item.block.ItemBlockVillager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class BlockVillager
extends Block {
    public final Logger LOG = CubicVillager.LOG;
    protected static IIcon face;
    protected static IIcon side;
    protected static IIcon bottom;
    public static int tickIdleSound;
    public static int chanceIdleSound;

    public BlockVillager() {
        this("villager_block_n", false);
    }

    protected BlockVillager(String name, boolean isTileEntity) {
        super(Material.field_151575_d);
        this.func_149649_H();
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(1.4f);
        this.func_149663_c(name);
        if (isTileEntity) {
            GameRegistry.registerBlock((Block)this, ItemBlockVillager.class, (String)name);
        } else {
            GameRegistry.registerBlock((Block)this, (String)name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int sideId, int metaData) {
        IIcon icon;
        switch (sideId) {
            case 0: {
                icon = bottom;
                break;
            }
            case 1: {
                icon = side;
                break;
            }
            default: {
                int sideForFace;
                switch (metaData) {
                    case 0: {
                        sideForFace = 3;
                        break;
                    }
                    case 1: {
                        sideForFace = 4;
                        break;
                    }
                    case 2: {
                        sideForFace = 2;
                        break;
                    }
                    case 3: {
                        sideForFace = 5;
                        break;
                    }
                    default: {
                        sideForFace = 0;
                    }
                }
                icon = sideId == sideForFace ? face : side;
            }
        }
        return icon;
    }

    public Item func_149650_a(int metaData, Random random, int par3) {
        return super.func_149650_a(metaData, random, par3);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147454_a(x, y, z, (Block)this, this.func_149738_a(world), -1);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        double yaw = Math.floor((double)(entity.field_70177_z / 360.0f * 4.0f) + 0.5);
        int direction = (int)yaw & 3;
        switch (direction) {
            case 0: {
                direction = 2;
                break;
            }
            case 1: {
                direction = 3;
                break;
            }
            case 2: {
                direction = 0;
                break;
            }
            case 3: {
                direction = 1;
            }
        }
        world.func_72921_c(x, y, z, direction, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        face = iconReg.func_94245_a("cubicvillager:VillagerBFace");
        side = iconReg.func_94245_a("cubicvillager:VillagerTop");
        bottom = iconReg.func_94245_a("cubicvillager:VillagerBottom");
    }

    public int func_149738_a(World world) {
        return tickIdleSound;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        try {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
        catch (StackOverflowError e) {
            this.LOG.warn("Oh\u2026 StackOverflowError\u2026");
        }
        if (chanceIdleSound < 0) {
            return;
        }
        if (random.nextInt(chanceIdleSound) == 0) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.villager.idle", 1.0f, 1.0f, false);
        }
    }

    static {
        tickIdleSound = 10;
        chanceIdleSound = 500;
    }
}

