/*
 * Decompiled with CFR 0.152.
 */
package mods.alice.cubicvillager.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.alice.cubicvillager.CubicVillager;
import mods.alice.cubicvillager.ItemManager;
import mods.alice.cubicvillager.block.BlockVillager;
import mods.alice.cubicvillager.item.ItemVillagerBlockelize;
import mods.alice.cubicvillager.tileentity.TileEntityVillager;
import mods.alice.cubicvillager.utility.ModLogger;
import mods.alice.cubicvillager.utility.VillagerData;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class BlockVillagerTrader
extends BlockVillager
implements ITileEntityProvider {
    public static int renderId;

    public BlockVillagerTrader() {
        super("villager_block_trade", true);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityVillager(world);
    }

    @Override
    public Item func_149650_a(int metaData, Random random, int par3) {
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntityVillager)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        VillagerData.tileToTag((TileEntityVillager)tile, tag);
        ItemStack stack = new ItemStack(item);
        stack.func_77982_d(tag);
        return stack;
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float px, float py, float pz) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityVillager)) {
            ModLogger.chatNotify(world, "\u00a74ERROR: Bad tile entity located at %d, %d, %d!\u00a7r", x, y, z);
            return false;
        }
        player.openGui((Object)CubicVillager.me, 0, world, x, y, z);
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int metaData, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileVillager = world.func_147438_o(x, y, z);
        boolean stick = false;
        ItemStack currentItemS = player.func_71045_bC();
        Item currentItem = null;
        if (currentItemS != null && (currentItem = currentItemS.func_77973_b()) == ItemManager.getItem(ItemVillagerBlockelize.class)) {
            stick = true;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (stick) {
                BlockVillagerTrader.dropTaggedBlock(world, x, y, z, true);
            }
        } else {
            BlockVillagerTrader.dropTaggedBlock(world, x, y, z, stick ? true : EnchantmentHelper.func_77502_d((EntityLivingBase)player));
        }
        if (tileVillager != null && tileVillager instanceof TileEntityVillager) {
            ItemStack[] itemStacks;
            for (ItemStack is : itemStacks = ((TileEntityVillager)tileVillager).getItemStacks()) {
                if (is == null) continue;
                EntityItem itemDrop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is);
                world.func_72838_d((Entity)itemDrop);
            }
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entity, itemStack);
        TileEntity tileVillager = world.func_147438_o(x, y, z);
        if (tileVillager == null || !(tileVillager instanceof TileEntityVillager)) {
            ModLogger.chatNotify(world, "\u00a74ERROR: Bad tile entity located at %d, %d, %d!\u00a7r", x, y, z);
            return;
        }
        NBTTagCompound tagItemStack = itemStack.func_77978_p();
        if (tagItemStack != null) {
            VillagerData.tagToTile(tagItemStack, (TileEntityVillager)tileVillager);
        }
        if (!entity.func_70093_af() && BlockVillagerTrader.checkUnderblocks(world, x, y, z)) {
            EntityVillager villager = new EntityVillager(world, -1);
            Random rng = villager.func_70681_au();
            if (!world.field_72995_K) {
                VillagerData.tagToVillager(tagItemStack, villager);
                villager.func_70107_b((double)x + 0.5, (double)y - 1.5, (double)z + 0.5);
                world.func_72838_d((Entity)villager);
            }
            for (int particle = 0; particle < 5; particle = (int)((byte)(particle + 1))) {
                world.func_72869_a("happyVillager", (double)x - 0.5 + rng.nextDouble() * 2.0, (double)y - 1.5 + rng.nextDouble() * 2.0, (double)z - 0.5 + rng.nextDouble() * 2.0, 0.0, 0.0, 0.0);
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                int amount = 18 + rng.nextInt(4);
                ItemStack drop = new ItemStack(Items.field_151166_bC, amount);
                EntityItem dropItem = new EntityItem(world, (double)x + 0.5, (double)y - 1.5, (double)z + 0.5, drop);
                world.func_72838_d((Entity)dropItem);
            }
            world.func_147468_f(x, y, z);
            world.func_147468_f(x, y - 1, z);
            world.func_147468_f(x, y - 2, z);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
    }

    private static boolean checkUnderblocks(World world, int x, int y, int z) {
        Block block;
        return y >= 2 && (block = world.func_147439_a(x, y - 1, z)) == Blocks.field_150475_bE && (block = world.func_147439_a(x, y - 2, z)) == Blocks.field_150475_bE;
    }

    public static void dropTaggedBlock(World world, int x, int y, int z, boolean isSilkTouch) {
        TileEntity tileVillager;
        if (world.field_72995_K) {
            return;
        }
        ItemStack itemStack = new ItemStack(ItemManager.getBlock(BlockVillagerTrader.class), 1, 0);
        if (isSilkTouch && (tileVillager = world.func_147438_o(x, y, z)) != null && tileVillager instanceof TileEntityVillager) {
            NBTTagCompound tag = new NBTTagCompound();
            VillagerData.tileToTag((TileEntityVillager)tileVillager, tag);
            itemStack.func_77982_d(tag);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, itemStack));
    }
}

