/*
 * Decompiled with CFR 0.152.
 */
package mods.alice.cubicvillager.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mods.alice.cubicvillager.CommonProxy;
import mods.alice.cubicvillager.CubicVillager;
import mods.alice.cubicvillager.network.UpdateTradeClientMessage;
import mods.alice.cubicvillager.tileentity.TileEntityVillager;
import mods.alice.cubicvillager.utility.TypeTransformer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public final class ChangeTradeMessage
implements IMessage,
IMessageHandler<ChangeTradeMessage, IMessage> {
    private int dimension;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int tradeIndex;

    public ChangeTradeMessage() {
    }

    public ChangeTradeMessage(TileEntityVillager tile, int tradeIndex) {
        World world = tile.func_145831_w();
        this.dimension = world.field_73011_w.field_76574_g;
        this.xCoord = tile.field_145851_c;
        this.yCoord = tile.field_145848_d;
        this.zCoord = tile.field_145849_e;
        this.tradeIndex = tradeIndex;
    }

    private void updateVillagerBlock(NetHandlerPlayServer server) {
        World world = server.field_147369_b.field_70170_p;
        if (world == null || world.field_73011_w.field_76574_g != this.dimension) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        if (tile == null || !(tile instanceof TileEntityVillager)) {
            return;
        }
        ((TileEntityVillager)tile).setTradeIndex(this.tradeIndex);
        world = tile.func_145831_w();
        CommonProxy proxy = CubicVillager.getProxy();
        SimpleNetworkWrapper netWrapper = proxy.simpleNetWrapper;
        AxisAlignedBB range = ((TileEntityVillager)tile).getUpdateRange();
        List playerList = world.func_72872_a(EntityPlayerMP.class, range);
        for (EntityPlayerMP player : playerList) {
            if (player == server.field_147369_b) continue;
            UpdateTradeClientMessage message = new UpdateTradeClientMessage((TileEntityVillager)tile);
            netWrapper.sendTo((IMessage)message, player);
        }
    }

    public IMessage onMessage(ChangeTradeMessage message, MessageContext ctx) {
        message.updateVillagerBlock(ctx.getServerHandler());
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readShort();
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.tradeIndex = TypeTransformer.fromUnsignedByte(buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.dimension);
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeByte((int)TypeTransformer.toUnsignedByte(this.tradeIndex));
    }
}

