/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager;

import alice.cubicvillager.CommonProxy;
import alice.cubicvillager.block.BlockVillager;
import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ModConfig {
    public Configuration configFile;

    public ModConfig(File configFilePath) {
        this.configFile = new Configuration(configFilePath);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        String modID = eventArgs.getModID();
        if (modID.equals("cubicvillager")) {
            this.syncConfig();
        }
    }

    public void syncConfig() {
        BlockVillager.chanceIdleSound = this.configFile.getInt("IdleSound_Chance", "general", 500, -1, Integer.MAX_VALUE, "1/n chance to play idle sound. Set -1 to disable.");
        BlockVillager.tickIdleSound = this.configFile.getInt("IdleSound_Tick", "general", 10, 10, Integer.MAX_VALUE, "Ticks to wait for take a chance to play idle sound.");
        CommonProxy.recipeVillagerSlabsIsRecovery = this.configFile.getBoolean("RecipeVillagerSlabsIsRecovery", "general", false, "When crafting with two villager slabs. If this value is true, it get villager block. Otherwise, it get vacant villager block.");
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    public ConfigCategory getCategory(String category) {
        return this.configFile.getCategory(category);
    }

    public String toString() {
        return this.configFile.toString();
    }
}

