/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.block;

import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.ItemManager;
import alice.cubicvillager.block.BlockVillager;
import alice.cubicvillager.block.state.BlockStateContainerVillager;
import alice.cubicvillager.item.ItemVillagerBlockelize;
import alice.cubicvillager.item.block.ItemBlockVillager;
import alice.cubicvillager.tileentity.TileEntityVillager;
import alice.cubicvillager.utility.ModLogger;
import alice.cubicvillager.utility.VillagerData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class BlockVillagerTrader
extends BlockVillager
implements ITileEntityProvider {
    public static final Enchantment SILKTOUCH = (Enchantment)Enchantment.field_185264_b.func_148754_a(33);

    public BlockVillagerTrader() {
        super("villager_block_trade", true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        ItemBlockVillager ib = new ItemBlockVillager((Block)this);
        ib.setRegistryName("villager_block_trade");
        ib.func_77655_b("villager_block_trade");
        GameRegistry.register((IForgeRegistryEntry)ib);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityVillager(world);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Item item = Item.func_150898_a((Block)this);
        if (item == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileEntityVillager)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        VillagerData.tileToTag((TileEntityVillager)tile, tag);
        ItemStack stack = new ItemStack(item);
        stack.func_77982_d(tag);
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float px, float py, float pz) {
        if (world.field_72995_K) {
            return true;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !(tileEntity instanceof TileEntityVillager)) {
            ModLogger.chatNotify((World)((WorldServer)world), "\u00a74ERROR: Bad tile entity located at %d, %d, %d!\u00a7r", x, y, z);
            return false;
        }
        player.openGui((Object)CubicVillager.me, 0, world, x, y, z);
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileVillager = world.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.field_71075_bZ.field_75098_d) {
            if (player.func_70093_af()) {
                BlockVillagerTrader.dropTaggedBlock(world, x, y, z, true);
            }
        } else {
            boolean stick = false;
            ItemStack currentItemS = player.func_184614_ca();
            if (currentItemS == null) {
                currentItemS = player.func_184592_cb();
            }
            Item currentItem = null;
            if (currentItemS != null && (currentItem = currentItemS.func_77973_b()) == ItemManager.getItem(ItemVillagerBlockelize.class)) {
                stick = true;
            }
            if (stick) {
                BlockVillagerTrader.dropTaggedBlock(world, x, y, z, true);
            } else {
                boolean silk = EnchantmentHelper.func_77506_a((Enchantment)SILKTOUCH, (ItemStack)currentItemS) > 0;
                BlockVillagerTrader.dropTaggedBlock(world, x, y, z, silk);
            }
        }
        if (tileVillager != null && tileVillager instanceof TileEntityVillager) {
            ItemStack[] itemStacks;
            for (ItemStack is : itemStacks = ((TileEntityVillager)tileVillager).tradeInventory) {
                if (is == null) continue;
                EntityItem itemDrop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is);
                world.func_72838_d((Entity)itemDrop);
            }
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, entity, itemStack);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        TileEntity tileVillager = world.func_175625_s(pos);
        if (tileVillager == null || !(tileVillager instanceof TileEntityVillager)) {
            if (!world.field_72995_K) {
                ModLogger.chatNotify((World)((WorldServer)world), "\u00a74ERROR: Bad tile entity located at %d, %d, %d!\u00a7r", x, y, z);
            }
            return;
        }
        NBTTagCompound tagItemStack = itemStack.func_77978_p();
        if (tagItemStack != null) {
            VillagerData.tagToTile(tagItemStack, (TileEntityVillager)tileVillager);
        }
        if (!entity.func_70093_af() && BlockVillagerTrader.checkUnderblocks(world, pos)) {
            EntityVillager villager = new EntityVillager(world);
            Random rng = villager.func_70681_au();
            if (!world.field_72995_K) {
                VillagerData.tagToVillager(tagItemStack, villager);
                villager.func_70107_b((double)x + 0.5, (double)y - 1.5, (double)z + 0.5);
                world.func_72838_d((Entity)villager);
            }
            if (!world.field_72995_K && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                int amount = 18 + rng.nextInt(4);
                ItemStack drop = new ItemStack(Items.field_151166_bC, amount);
                EntityItem dropItem = new EntityItem(world, (double)x + 0.5, (double)y - 1.5, (double)z + 0.5, drop);
                world.func_72838_d((Entity)dropItem);
            }
            world.func_175698_g(pos);
            BlockPos posDown = pos.func_177977_b();
            world.func_175698_g(posDown);
            posDown = posDown.func_177977_b();
            world.func_175698_g(posDown);
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerVillager((Block)this, new IProperty[]{field_185512_D});
    }

    private static boolean checkUnderblocks(World world, BlockPos vPos) {
        BlockPos pos;
        IBlockState block;
        return vPos.func_177956_o() >= 2 && Blocks.field_150475_bE.equals((block = world.func_180495_p(pos = vPos.func_177977_b())).func_177230_c()) && Blocks.field_150475_bE.equals((block = world.func_180495_p(pos = pos.func_177977_b())).func_177230_c());
    }

    public static void dropTaggedBlock(World world, int x, int y, int z, boolean isSilkTouch) {
        TileEntity tileVillager;
        if (world.field_72995_K) {
            return;
        }
        ItemStack itemStack = new ItemStack(ItemManager.getBlock(BlockVillagerTrader.class), 1, 0);
        if (isSilkTouch && (tileVillager = world.func_175625_s(new BlockPos(x, y, z))) != null && tileVillager instanceof TileEntityVillager) {
            NBTTagCompound tag = new NBTTagCompound();
            VillagerData.tileToTag((TileEntityVillager)tileVillager, tag);
            itemStack.func_77982_d(tag);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, itemStack));
    }
}

