/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.inventory;

import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.TradeInfo;
import alice.cubicvillager.inventory.InventoryMerchantEditor;
import alice.cubicvillager.inventory.SlotVirtual;
import alice.cubicvillager.network.SyncSlotMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public final class ContainerMerchantEditor
extends Container {
    private final SimpleNetworkWrapper wrapper;
    public final InventoryMerchantEditor inventory = new InventoryMerchantEditor(this);
    public final IMerchant merchant;
    public final EntityPlayer player;
    private List<TradeInfo> tradeList = new ArrayList<TradeInfo>();
    private int currentTradeIndex;

    public ContainerMerchantEditor(IMerchant merchant, InventoryPlayer playerInventory) {
        int i;
        this.wrapper = CubicVillager.proxy.simpleNetWrapper;
        this.merchant = merchant;
        this.player = playerInventory.field_70458_d;
        MerchantRecipeList trades = merchant.func_70934_b(playerInventory.field_70458_d);
        if (trades != null) {
            for (Object recipe : trades) {
                this.tradeList.add(new TradeInfo((MerchantRecipe)recipe));
            }
        }
        this.loadTradeAt(0);
        this.func_75146_a(new SlotVirtual(this.inventory, 0, 36, 24));
        this.func_75146_a(new SlotVirtual(this.inventory, 1, 62, 24));
        this.func_75146_a(new SlotVirtual(this.inventory, 2, 120, 24));
        for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < 9; j = (int)((byte)(j + 1))) {
                int slotIndex = 9 + 9 * i + j;
                this.func_75146_a(new Slot((IInventory)playerInventory, slotIndex, 8 + j * 18, 78 + i * 18));
            }
        }
        for (i = 0; i < 9; i = (int)((byte)(i + 1))) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 136));
        }
    }

    private void loadTrade() {
        int tradeSize = this.tradeList.size();
        if (this.currentTradeIndex < 0) {
            this.currentTradeIndex = 0;
        } else if (this.currentTradeIndex >= tradeSize) {
            this.currentTradeIndex = tradeSize == 0 ? 0 : tradeSize - 1;
        }
        if (tradeSize == 0) {
            this.inventory.setTrade(null);
        } else {
            TradeInfo trade = this.tradeList.get(this.currentTradeIndex);
            this.inventory.setTrade(trade);
        }
        this.wrapper.sendToServer((IMessage)new SyncSlotMessage(1, this.currentTradeIndex));
    }

    public void nextRecipe() {
        ++this.currentTradeIndex;
        this.loadTrade();
    }

    public void previousRecipe() {
        --this.currentTradeIndex;
        this.loadTrade();
    }

    public int loadTradeAt(int index) {
        this.currentTradeIndex = index;
        this.loadTrade();
        return this.currentTradeIndex;
    }

    public boolean hasNextFromCurrent() {
        int recipeSize = this.tradeList.size();
        return this.currentTradeIndex + 1 < recipeSize;
    }

    public boolean hasPreviousFromCurrent() {
        return this.currentTradeIndex > 0;
    }

    public int getNumberOfTrades() {
        return this.tradeList.size();
    }

    public int getCurrentTradeIndex() {
        return this.currentTradeIndex;
    }

    public TradeInfo getCurrentTrade() {
        TradeInfo trade = this.tradeList.get(this.currentTradeIndex);
        return trade.clone();
    }

    public void refreshTrades(List<TradeInfo> trades) {
        this.tradeList.clear();
        this.tradeList.addAll(trades);
        this.loadTradeAt(0);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_94531_b(Slot slot) {
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        return null;
    }
}

