/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Inventory {
    public final int slots;
    protected final Map<Integer, ItemStack> inventory;

    public Inventory(int slots) {
        this.slots = slots;
        this.inventory = new HashMap<Integer, ItemStack>();
    }

    public Inventory(int slots, NBTTagCompound tags) {
        this(slots);
        this.readFromNBT(tags);
    }

    public void add(ItemStack newItem) {
        int maxStack;
        ItemStack inventoryItem;
        Integer slotKey;
        Iterator<Integer> iterator = this.getKeyIterator();
        while (iterator.hasNext()) {
            slotKey = iterator.next();
            inventoryItem = this.inventory.get(slotKey);
            if (inventoryItem.func_77969_a(newItem)) {
                maxStack = inventoryItem.func_77976_d();
                if (inventoryItem.field_77994_a + newItem.field_77994_a > maxStack) {
                    newItem.field_77994_a = maxStack - inventoryItem.field_77994_a;
                    inventoryItem.field_77994_a = maxStack;
                } else {
                    inventoryItem.field_77994_a += newItem.field_77994_a;
                    newItem.field_77994_a = 0;
                }
            }
            if (newItem.field_77994_a > 0) continue;
        }
        if (newItem.field_77994_a <= 0) {
            return;
        }
        HashMap<Integer, ItemStack> newingInventory = new HashMap<Integer, ItemStack>();
        for (int slot = 0; slot < this.slots; ++slot) {
            slotKey = new Integer(slot);
            inventoryItem = this.inventory.get(slotKey);
            if (inventoryItem == null) {
                inventoryItem = newItem.func_77946_l();
                maxStack = inventoryItem.func_77976_d();
                if (inventoryItem.field_77994_a > maxStack) {
                    inventoryItem.field_77994_a = maxStack;
                }
                newItem.field_77994_a -= inventoryItem.field_77994_a;
                newingInventory.put(slot, inventoryItem);
            }
            if (newItem.field_77994_a <= 0) break;
        }
        this.inventory.putAll(newingInventory);
    }

    public void add(ItemStack[] items) {
        for (ItemStack item : items) {
            this.add(item);
        }
    }

    public ItemStack indexOf(int slot) {
        return this.inventory.get(new Integer(slot));
    }

    public ItemStack get(int slot, int amount) {
        ItemStack newItemStack;
        Integer slotKey = new Integer(slot);
        ItemStack inventoryItem = this.inventory.get(slot);
        if (slot >= this.slots) {
            return null;
        }
        if (inventoryItem == null) {
            return null;
        }
        if (amount <= inventoryItem.field_77994_a) {
            newItemStack = inventoryItem.func_77946_l();
            newItemStack.field_77994_a = amount;
            inventoryItem.field_77994_a -= amount;
        } else {
            newItemStack = inventoryItem.func_77946_l();
            newItemStack.field_77994_a = amount;
            inventoryItem.field_77994_a = 0;
        }
        if (inventoryItem.field_77994_a <= 0) {
            this.inventory.remove(slotKey);
        }
        return newItemStack;
    }

    public ItemStack getItem(ItemStack item, int amount) {
        ItemStack inventoryItem;
        Iterator<Integer> iterator = this.getKeyIterator();
        ItemStack newItemStack = null;
        int remain = amount;
        ArrayList<Integer> takeList = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            Integer slotKey = iterator.next();
            inventoryItem = this.inventory.get(slotKey);
            if (inventoryItem.func_77969_a(item)) {
                takeList.add(slotKey);
                remain -= inventoryItem.field_77994_a;
            }
            if (remain > 0) continue;
        }
        remain = amount;
        int taken = 0;
        for (Integer slot : takeList) {
            inventoryItem = this.get(slot, remain);
            taken += inventoryItem.field_77994_a;
            if ((remain -= inventoryItem.field_77994_a) > 0) continue;
            break;
        }
        newItemStack = item.func_77946_l();
        newItemStack.field_77994_a = taken;
        return newItemStack;
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.readFromNBT(tags, "Inventory");
    }

    public void readFromNBT(NBTTagCompound tags, String inventoryTagName) {
        NBTTagList items = tags.func_150295_c(inventoryTagName, 10);
        if (items == null) {
            return;
        }
        int tagCount = items.func_74745_c();
        if (tagCount <= 0) {
            return;
        }
        for (int tagIndex = 0; tagIndex < tagCount && tagIndex < this.slots; ++tagIndex) {
            NBTTagCompound base = items.func_150305_b(tagIndex);
            if (!(base instanceof NBTTagCompound)) continue;
            try {
                if (!base.func_74764_b("slt")) continue;
                byte slot = base.func_74771_c("slt");
                Integer slotKey = new Integer(slot);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)base);
                this.inventory.put(slotKey, itemStack);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        this.writeToNBT(tags, "Inventory");
    }

    public void writeToNBT(NBTTagCompound tags, String inventoryTagName) {
        Iterator<Integer> iterator = this.getKeyIterator();
        NBTTagList items = new NBTTagList();
        while (iterator.hasNext()) {
            Integer slotKey = iterator.next();
            ItemStack inventoryItem = this.inventory.get(slotKey);
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", slotKey.byteValue());
            try {
                inventoryItem.func_77955_b(item);
            }
            catch (Exception e) {
                item = null;
            }
            if (item == null) continue;
            items.func_74742_a((NBTBase)item);
        }
        tags.func_74782_a(inventoryTagName, (NBTBase)items);
    }

    private Iterator<Integer> getKeyIterator() {
        Set<Integer> keySet = this.inventory.keySet();
        return keySet.iterator();
    }
}

