/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.item;

import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.ItemManager;
import alice.cubicvillager.block.BlockVillagerTrader;
import alice.cubicvillager.utility.VillagerData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemVillagerBlockelize
extends Item {
    public ItemVillagerBlockelize() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77664_n();
        this.func_77656_e(42);
        this.func_77625_d(1);
        this.setRegistryName("villager_blockelize");
        this.func_77655_b("villager_blockelize");
        GameRegistry.register((IForgeRegistryEntry)this);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.field_71075_bZ.field_75098_d) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        ItemStack[] playerInventory = playerIn.field_71071_by.field_70462_a;
        for (int index = 0; index < playerInventory.length; ++index) {
            if (playerInventory[index] == null || playerInventory[index].func_77973_b() != Items.field_151166_bC || playerInventory[index].field_77994_a <= 0) continue;
            int itemDamage = itemStackIn.func_77952_i();
            if (itemDamage <= 0) break;
            --playerInventory[index].field_77994_a;
            if (playerInventory[index].field_77994_a <= 0) {
                playerInventory[index] = null;
            }
            if ((itemDamage -= 21) < 0) {
                itemDamage = 0;
            }
            itemStackIn.func_77964_b(itemDamage);
            break;
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int damage;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (!ItemVillagerBlockelize.isVillagerBlock(world, pos)) {
            return EnumActionResult.FAIL;
        }
        if (player.field_71075_bZ.field_75098_d) {
            player.openGui((Object)CubicVillager.me, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        if (!player.field_71075_bZ.field_75098_d && (damage = 2 + itemStack.func_77952_i()) > itemStack.func_77958_k()) {
            return EnumActionResult.FAIL;
        }
        IBlockState villagerBlock = world.func_180495_p(pos);
        Block vb = villagerBlock.func_177230_c();
        vb.func_176208_a(world, pos, villagerBlock, player);
        world.func_175655_b(pos, false);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_77964_b(itemStack.func_77952_i() + 2);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityZombie) {
            if (!((EntityZombie)entity).func_82231_m()) {
                return false;
            }
            boolean power = false;
            int emeraldAt = -1;
            int appleAt = -1;
            if (!player.field_70170_p.field_72995_K) {
                InventoryPlayer inv = player.field_71071_by;
                if (player.field_71075_bZ.field_75098_d) {
                    power = true;
                } else {
                    int invElements = inv.func_70302_i_();
                    for (int i = 0; i < invElements; ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack == null) continue;
                        Item item = stack.func_77973_b();
                        if (item == Items.field_151153_ao && appleAt == -1) {
                            if (stack.func_77952_i() != 0) continue;
                            appleAt = i;
                            continue;
                        }
                        if (item != Items.field_151166_bC || emeraldAt != -1) continue;
                        emeraldAt = i;
                    }
                    if (appleAt == -1) {
                        return false;
                    }
                    if (emeraldAt == -1) {
                        int damage = itemStack.func_77952_i();
                        int maxDamage = itemStack.func_77958_k();
                        if ((damage += 21) <= maxDamage) {
                            itemStack.func_77964_b(damage);
                            power = true;
                        }
                    } else {
                        power = true;
                    }
                }
                if (power) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        inv.func_70298_a(appleAt, 1);
                        inv.func_70298_a(emeraldAt, 1);
                    }
                    ((EntityZombie)entity).func_82232_p();
                }
            }
            return power;
        }
        if (!(entity instanceof EntityVillager)) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            int damage;
            if (!player.field_71075_bZ.field_75098_d && (damage = 1 + itemStack.func_77952_i()) > itemStack.func_77958_k()) {
                return false;
            }
            if (((EntityVillager)entity).func_70631_g_()) {
                ((EntityVillager)entity).func_70873_a(1);
                ((EntityLiving)entity).func_70636_d();
            }
            ItemStack newItemStack = new ItemStack(ItemManager.getBlock(BlockVillagerTrader.class), 1, 0);
            NBTTagCompound tagItemStack = new NBTTagCompound();
            VillagerData.villagerToTag((EntityVillager)entity, tagItemStack);
            newItemStack.func_77982_d(tagItemStack);
            EntityItem itemDrop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, newItemStack);
            player.field_70170_p.func_72838_d((Entity)itemDrop);
        }
        Random rng = ((EntityVillager)entity).func_70681_au();
        for (int prof = 0; prof < 5; ++prof) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t - 0.5 + rng.nextDouble() * 2.0, entity.field_70163_u - 0.5 + rng.nextDouble() * 2.0, entity.field_70161_v - 0.5 + rng.nextDouble() * 2.0, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!player.field_70170_p.field_72995_K) {
            entity.func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_77964_b(itemStack.func_77952_i() + 1);
            }
        }
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return ItemVillagerBlockelize.isVillagerBlock((World)world, pos);
    }

    protected static boolean isVillagerBlock(World world, BlockPos pos) {
        Block villagerBlock = ItemManager.getBlock(BlockVillagerTrader.class);
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_177230_c() == villagerBlock;
    }
}

