/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.item.block;

import alice.cubicvillager.utility.TypeTransformer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockVillager
extends ItemBlock {
    protected static final FMLControlledNamespacedRegistry<VillagerRegistry.VillagerProfession> PROFESSIONS = (FMLControlledNamespacedRegistry)VillagerRegistry.instance().getRegistry();

    public ItemBlockVillager(Block block) {
        super(block);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("cubicvillager", "villager_itemblock_trade"), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean detailMode) {
        String professionString;
        NBTTagCompound tagItemStack = itemStack.func_77978_p();
        if (tagItemStack == null) {
            return;
        }
        StringBuilder tooltip = new StringBuilder();
        String name = tagItemStack.func_74779_i("Name");
        if (name != null && name.length() > 0) {
            tooltip.append("Name:\u00a7b");
            tooltip.append(name);
            tooltip.append("\u00a7r");
            list.add(tooltip.toString());
        }
        if ((professionString = tagItemStack.func_74779_i("prf")) == null || professionString.length() == 0) {
            professionString = "minecraft:farmer";
        }
        ResourceLocation professionName = new ResourceLocation(professionString);
        VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)PROFESSIONS.getObject(professionName);
        int careerId = TypeTransformer.fromUnsignedByte(tagItemStack.func_74771_c("car"));
        VillagerRegistry.VillagerCareer career = profession.getCareer(careerId);
        tooltip = new StringBuilder();
        tooltip.append("entity.Villager.");
        tooltip.append(career.getName());
        String localizedCareer = I18n.func_135052_a((String)tooltip.toString(), (Object[])new Object[0]);
        tooltip = new StringBuilder();
        tooltip.append("Profession:\u00a7b");
        tooltip.append(localizedCareer);
        tooltip.append("\u00a7r");
        list.add(tooltip.toString());
        tooltip = new StringBuilder();
        tooltip.append("Level:\u00a7b");
        tooltip.append(TypeTransformer.fromUnsignedByte(tagItemStack.func_74771_c("lov")));
        tooltip.append("\u00a7r");
        list.add(tooltip.toString());
    }
}

