/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.network;

import alice.cubicvillager.CommonProxy;
import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.network.UpdateTradeClientMessage;
import alice.cubicvillager.tileentity.TileEntityVillager;
import alice.cubicvillager.utility.TypeTransformer;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public final class ChangeTradeMessage
implements IMessage,
IMessageHandler<ChangeTradeMessage, IMessage> {
    private int dimension;
    private BlockPos pos;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int tradeIndex;

    public ChangeTradeMessage() {
    }

    public ChangeTradeMessage(TileEntityVillager tile, int tradeIndex) {
        World world = tile.func_145831_w();
        this.dimension = world.field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        this.xCoord = this.pos.func_177958_n();
        this.yCoord = this.pos.func_177956_o();
        this.zCoord = this.pos.func_177952_p();
        this.tradeIndex = tradeIndex;
    }

    private void updateVillagerBlock(NetHandlerPlayServer server) {
        TileEntity tile;
        World world = server.field_147369_b.field_70170_p;
        if (world == null || world.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        if (this.pos == null) {
            this.pos = new BlockPos(this.xCoord, this.yCoord, this.zCoord);
        }
        if ((tile = world.func_175625_s(this.pos)) == null || !(tile instanceof TileEntityVillager)) {
            return;
        }
        ((TileEntityVillager)tile).setTradeIndex(this.tradeIndex);
        world = tile.func_145831_w();
        CommonProxy proxy = CubicVillager.getProxy();
        SimpleNetworkWrapper netWrapper = proxy.simpleNetWrapper;
        AxisAlignedBB range = ((TileEntityVillager)tile).getUpdateRange();
        List playerList = world.func_72872_a(EntityPlayerMP.class, range);
        for (EntityPlayerMP player : playerList) {
            if (player == server.field_147369_b) continue;
            UpdateTradeClientMessage message = new UpdateTradeClientMessage((TileEntityVillager)tile);
            netWrapper.sendTo((IMessage)message, player);
        }
    }

    public IMessage onMessage(ChangeTradeMessage message, MessageContext ctx) {
        message.updateVillagerBlock(ctx.getServerHandler());
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readShort();
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.tradeIndex = TypeTransformer.fromUnsignedByte(buf.readByte());
        this.pos = new BlockPos(this.xCoord, this.yCoord, this.zCoord);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.dimension);
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeByte((int)TypeTransformer.toUnsignedByte(this.tradeIndex));
    }
}

