/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.tileentity;

import alice.cubicvillager.utility.Trader;
import alice.cubicvillager.utility.VillagerData;
import java.util.Random;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class TileEntityVillager
extends TileEntity
implements ISidedInventory,
IMerchant,
ITickable {
    protected static final int[] accessibleIndexes = new int[]{0, 1, 2};
    protected MerchantRecipeList tradeList;
    protected static final MerchantRecipeList emptyTrades = new MerchantRecipeList();
    public final ItemStack[] tradeInventory = new ItemStack[3];
    public final ItemStack[] inventory = new ItemStack[8];
    protected VillagerRegistry.VillagerProfession vp;
    protected String profession;
    protected int career;
    public int love;
    protected int tradeIndex;
    private AxisAlignedBB updateRange;
    private BlockPos updateRangeCenter;
    protected ItemStack[] cacheTradeSells = new ItemStack[2];
    protected ItemStack[] cacheTradeSellsRecipe = new ItemStack[2];
    private String name;
    private boolean noTrade;

    public TileEntityVillager() {
    }

    public TileEntityVillager(World world) {
        this.field_145850_b = world;
        EntityVillager dummyVillager = new EntityVillager(world);
        VillagerRegistry.setRandomProfession((EntityVillager)dummyVillager, (Random)dummyVillager.func_70681_au());
        this.profession = dummyVillager.getProfessionForge().getRegistryName().toString();
        this.career = dummyVillager.field_175563_bv;
        this.love = dummyVillager.field_175562_bw;
        this.tradeList = dummyVillager.func_70934_b(null);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        VillagerData.tileToTagWithItems(this, tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        VillagerData.tileToTagWithItems(this, tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag;
        if (pkt.func_179823_a().equals((Object)this.field_174879_c) && pkt.func_148853_f() == 1 && (tag = pkt.func_148857_g()) != null) {
            VillagerData.tagToTile(tag, this);
        }
    }

    public void setProfession(String profession) {
        FMLControlledNamespacedRegistry p = (FMLControlledNamespacedRegistry)VillagerRegistry.instance().getRegistry();
        this.vp = (VillagerRegistry.VillagerProfession)p.getObject(new ResourceLocation(profession));
        this.profession = profession;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setCareer(int career) {
        this.career = career;
    }

    public int getCareer() {
        return this.career;
    }

    public MerchantRecipeList getTrades() {
        return this.tradeList;
    }

    public void setTrades(MerchantRecipeList tradeList) {
        if (tradeList.size() == 0) {
            this.setNoTrades();
        } else {
            this.noTrade = false;
            this.tradeList = tradeList;
            this.setTradeIndex(this.getTradeIndex());
        }
    }

    public void setNoTrades() {
        this.noTrade = true;
        this.tradeList = emptyTrades;
        this.tradeIndex = -1;
    }

    public boolean isEmptyTrades() {
        return this.noTrade;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            this.name = null;
        } else if (this.name == null || !this.name.equals(name)) {
            this.name = name;
        }
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int index) {
        if (this.tradeList.size() == 0) {
            this.tradeIndex = -1;
            return;
        }
        if (index < 0) {
            index = 0;
        } else {
            int lastIndex = this.tradeList.size() - 1;
            if (index > lastIndex) {
                index = lastIndex;
            }
        }
        this.tradeIndex = index;
    }

    public AxisAlignedBB getUpdateRange() {
        if (this.updateRange == null || this.field_174879_c.equals((Object)this.updateRangeCenter)) {
            this.updateRange();
        }
        return this.updateRange;
    }

    private void updateRange() {
        double oX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double oY = (double)this.field_174879_c.func_177956_o() + 0.5;
        double oZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.updateRange = new AxisAlignedBB(oX - 8.0, oY - 8.0, oZ - 8.0, oX + 8.0, oY + 8.0, oZ + 8.0);
        this.updateRangeCenter = this.field_174879_c;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        VillagerData.tagToTile(tagCompound, this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        VillagerData.tileToTagWithItems(this, tagCompound);
        return tagCompound;
    }

    public void func_73660_a() {
        int buy2;
        if (emptyTrades.size() > 0) {
            throw new IllegalStateException("emptyTrades\u306f\u7a7a\u30ea\u30b9\u30c8\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tradeList.size() == 0) {
            return;
        }
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return;
        }
        MerchantRecipe r = (MerchantRecipe)this.tradeList.get(this.tradeIndex);
        if (this.tradeInventory[2] != null && !Trader.isItemStackable(this.tradeInventory[2], r.field_77402_c)) {
            return;
        }
        int buy1 = this.tradeInventory[0] != null ? this.tradeInventory[0].field_77994_a : 0;
        int n = buy2 = this.tradeInventory[1] != null ? this.tradeInventory[1].field_77994_a : 0;
        if (Trader.doTrade(r, this.tradeInventory[0], this.tradeInventory[1], this.tradeInventory[2], false)) {
            if (this.tradeInventory[0] != null && this.tradeInventory[0].field_77994_a <= 0) {
                this.tradeInventory[0] = null;
            }
            if (this.tradeInventory[1] != null && this.tradeInventory[1].field_77994_a <= 0) {
                this.tradeInventory[1] = null;
            }
            if (Trader.isItemStackable(r.field_77402_c, this.tradeInventory[2])) {
                int newStacks = this.tradeInventory[2].field_77994_a;
                int limits = this.tradeInventory[2].func_77985_e() ? this.tradeInventory[2].func_77976_d() : 1;
                if ((newStacks += r.field_77402_c.field_77994_a) <= limits) {
                    this.tradeInventory[2].field_77994_a = newStacks;
                }
            } else if (this.tradeInventory[2] == null) {
                this.tradeInventory[2] = r.field_77402_c.func_77946_l();
            }
        } else {
            if (this.tradeInventory[0] != null) {
                this.tradeInventory[0].field_77994_a = buy1;
            }
            if (this.tradeInventory[1] != null) {
                this.tradeInventory[1].field_77994_a = buy2;
            }
        }
    }

    public int func_70302_i_() {
        return this.tradeInventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return null;
        }
        return this.tradeInventory[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return null;
        }
        if (this.tradeInventory[index] != null) {
            if (this.tradeInventory[index].field_77994_a <= amount) {
                ItemStack itemstack = this.tradeInventory[index];
                this.tradeInventory[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.tradeInventory[index].func_77979_a(amount);
            if (this.tradeInventory[index].field_77994_a == 0) {
                this.tradeInventory[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return;
        }
        this.tradeInventory[index] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        double zCoord;
        double yCoord;
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double xCoord = (double)this.field_174879_c.func_177958_n() + 0.5;
        return !(player.func_70092_e(xCoord, yCoord = (double)this.field_174879_c.func_177956_o() + 0.5, zCoord = (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return accessibleIndexes;
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing direction) {
        return index != 2;
    }

    public boolean func_180461_b(int index, ItemStack itemstack, EnumFacing direction) {
        return index == 2;
    }

    public void func_70932_a_(EntityPlayer entityplayer) {
    }

    public EntityPlayer func_70931_l_() {
        return null;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer entityplayer) {
        return this.getTrades();
    }

    public void func_70930_a(MerchantRecipeList merchantrecipelist) {
        this.setTrades(merchantrecipelist);
    }

    public void func_70933_a(MerchantRecipe merchantrecipe) {
    }

    public void func_110297_a_(ItemStack tradeResult) {
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

