/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.utility;

import alice.cubicvillager.tileentity.TileEntityVillager;
import alice.cubicvillager.utility.TypeTransformer;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public final class VillagerData {
    private static final NBTTagCompound noTradeRecipe = new NBTTagCompound();

    public static void tileToTag(TileEntityVillager tileVillager, NBTTagCompound tag) {
        tag.func_74778_a("prf", tileVillager.getProfession());
        tag.func_74774_a("car", TypeTransformer.toUnsignedByte(tileVillager.getCareer()));
        tag.func_74774_a("lov", TypeTransformer.toUnsignedByte(tileVillager.love));
        if (tileVillager.isEmptyTrades()) {
            tag.func_74757_a("ntr", true);
        } else {
            NBTTagCompound savedTradeRecipes;
            tag.func_74757_a("ntr", false);
            MerchantRecipeList trade = tileVillager.getTrades();
            try {
                savedTradeRecipes = trade.func_77202_a();
            }
            catch (Exception e) {
                tag.func_74757_a("ntr", true);
                savedTradeRecipes = null;
            }
            if (savedTradeRecipes != null) {
                tag.func_74782_a("trd", (NBTBase)savedTradeRecipes);
            }
        }
        String name = tileVillager.func_70005_c_();
        if (name != null) {
            tag.func_74778_a("nam", name);
        }
        NBTTagList items = new NBTTagList();
        tag.func_74782_a("inv", (NBTBase)items);
        VillagerData.inventoryToTag(tileVillager.inventory, items);
    }

    public static void tileToTagWithItems(TileEntityVillager tileVillager, NBTTagCompound tag) {
        VillagerData.tileToTag(tileVillager, tag);
        if (!tileVillager.isEmptyTrades()) {
            tag.func_74774_a("tix", TypeTransformer.toUnsignedByte(tileVillager.getTradeIndex()));
        } else {
            tag.func_74774_a("tix", TypeTransformer.toUnsignedByte(0));
        }
        NBTTagList items = new NBTTagList();
        tag.func_74782_a("itm", (NBTBase)items);
        VillagerData.inventoryToTag(tileVillager.tradeInventory, items);
    }

    public static void tagToTile(NBTTagCompound tag, TileEntityVillager tileVillager) {
        NBTTagList items;
        tileVillager.setProfession(tag.func_74779_i("prf"));
        tileVillager.setCareer(TypeTransformer.fromUnsignedByte(tag.func_74771_c("car")));
        tileVillager.love = TypeTransformer.fromUnsignedByte(tag.func_74771_c("lov"));
        if (tag.func_74767_n("ntr")) {
            tileVillager.setNoTrades();
        } else {
            MerchantRecipeList list;
            NBTTagCompound savedTradeRecipes = tag.func_74775_l("trd");
            if (savedTradeRecipes != null && (list = new MerchantRecipeList(savedTradeRecipes)) != null && list.size() > 0) {
                tileVillager.setTrades(list);
            }
            byte tradeIndex = tag.func_74771_c("tix");
            tileVillager.setTradeIndex(TypeTransformer.fromUnsignedByte(tradeIndex));
        }
        if (tag.func_74764_b("itm")) {
            items = tag.func_150295_c("itm", 10);
            VillagerData.tagToInventory(items, tileVillager.tradeInventory);
        }
        if (tag.func_74764_b("inv")) {
            items = tag.func_150295_c("inv", 10);
            VillagerData.tagToInventory(items, tileVillager.inventory);
        }
        if (tag.func_74764_b("nam")) {
            String name = tag.func_74779_i("nam");
            tileVillager.setName(name);
        }
    }

    public static void villagerToTag(EntityVillager villager, NBTTagCompound tag) {
        MerchantRecipeList recipes = villager.func_70934_b(null);
        if (recipes != null && recipes.size() == 0) {
            tag.func_74757_a("ntr", true);
        } else {
            tag.func_74757_a("ntr", false);
            if (recipes != null) {
                for (Object recipe : recipes) {
                    ((MerchantRecipe)recipe).field_77400_d = 0;
                }
                NBTTagCompound tagVillager = recipes.func_77202_a();
                tag.func_74782_a("trd", (NBTBase)tagVillager);
            }
        }
        VillagerRegistry.VillagerProfession prof = villager.getProfessionForge();
        ResourceLocation regName = prof.getRegistryName();
        tag.func_74778_a("prf", regName.toString());
        tag.func_74768_a("car", villager.field_175563_bv);
        tag.func_74768_a("lov", villager.field_175562_bw);
        String name = villager.func_95999_t();
        if (name != null && name.length() > 0) {
            tag.func_74778_a("nam", name);
        }
        NBTTagList items = new NBTTagList();
        tag.func_74782_a("inv", (NBTBase)items);
        InventoryBasic villagerInventory = villager.func_175551_co();
        VillagerData.inventoryToTag(villagerInventory, items);
    }

    public static void tagToVillager(NBTTagCompound tag, EntityVillager villager) {
        NBTTagList items;
        String name;
        if (tag == null) {
            return;
        }
        NBTTagCompound tagVillager = new NBTTagCompound();
        String profession = tag.func_74779_i("prf");
        tagVillager.func_74778_a("ProfessionName", profession);
        byte career = tag.func_74771_c("car");
        tagVillager.func_74768_a("Career", TypeTransformer.fromUnsignedByte(career));
        byte love = tag.func_74771_c("lov");
        tagVillager.func_74768_a("Level", TypeTransformer.fromUnsignedByte(love));
        if (tag.func_74767_n("ntr")) {
            tagVillager.func_74782_a("Offers", (NBTBase)noTradeRecipe);
        } else {
            NBTTagCompound savedTradeRecipes = tag.func_74775_l("trd");
            if (savedTradeRecipes != null) {
                tagVillager.func_74782_a("Offers", (NBTBase)savedTradeRecipes);
            }
        }
        if (tag.func_74764_b("nam") && (name = tag.func_74779_i("nam")).length() > 0) {
            villager.func_96094_a(name);
        }
        if ((items = tag.func_150295_c("inv", 10)) == null) {
            items = new NBTTagList();
        }
        tagVillager.func_74782_a("Inventory", (NBTBase)items);
        villager.func_70037_a(tagVillager);
        MerchantRecipeList recipes = villager.func_70934_b(null);
        for (Object recipe : recipes) {
            ((MerchantRecipe)recipe).field_77400_d = 0;
        }
    }

    public static void inventoryToTag(ItemStack[] inv, NBTTagList tag) {
        int invSize = inv.length;
        for (int i = 0; i < invSize; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            tag.func_74742_a((NBTBase)item);
            item.func_74774_a("slt", TypeTransformer.toUnsignedByte(i));
            inv[i].func_77955_b(item);
        }
    }

    public static void inventoryToTag(InventoryBasic inv, NBTTagList tag) {
        int elements = inv.func_70302_i_();
        ItemStack[] _inv = new ItemStack[elements];
        for (int i = 0; i < elements; ++i) {
            _inv[i] = inv.func_70301_a(i);
        }
        VillagerData.inventoryToTag(_inv, tag);
    }

    public static int tagToInventory(NBTTagList tag, ItemStack[] inv) {
        if (tag == null) {
            return 0;
        }
        int tagElements = tag.func_74745_c();
        if (tagElements == 0) {
            return 0;
        }
        int invElements = inv.length;
        if (invElements == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tagElements && i < invElements; ++i) {
            NBTTagCompound base = tag.func_150305_b(i);
            try {
                int slot = TypeTransformer.fromUnsignedByte(base.func_74771_c("slt"));
                inv[slot] = ItemStack.func_77949_a((NBTTagCompound)base);
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public static int tagToInventory(NBTTagList tag, InventoryBasic inv) {
        int elements = inv.func_70302_i_();
        ItemStack[] _inv = new ItemStack[elements];
        int e = VillagerData.tagToInventory(tag, _inv);
        for (int i = 0; i < elements; ++i) {
            inv.func_70299_a(i, _inv[i]);
        }
        return e;
    }
}

