/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager;

import alice.cubicvillager.block.BlockVillager;
import alice.cubicvillager.block.BlockVillagerTrader;
import alice.cubicvillager.item.ItemWand;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ItemManager {
    private static final Map<String, Block> blockMap = new HashMap<String, Block>();
    private static final Map<String, Item> itemMap = new HashMap<String, Item>();
    private static final Map<String, ItemBlock> itemBlockMap = new HashMap<String, ItemBlock>();

    private static void addBlock(String name, Block block) {
        ItemBlock itemBlock = new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        ItemManager.addBlock(name, block, itemBlock);
    }

    private static void addBlock(String name, Block block, ItemBlock itemBlock) {
        blockMap.put(name, block);
        itemBlockMap.put(name, itemBlock);
    }

    private static void addItem(String name, Item item) {
        itemMap.put(name, item);
    }

    public static void registerBlocks(IForgeRegistry<Block> reg) {
        for (String key : blockMap.keySet()) {
            Block block = ItemManager.getBlock(key);
            reg.register((IForgeRegistryEntry)block);
        }
    }

    public static void registerItems(IForgeRegistry<Item> reg) {
        Item item;
        for (String key : itemMap.keySet()) {
            item = ItemManager.getItem(key);
            reg.register((IForgeRegistryEntry)item);
        }
        for (String key : itemBlockMap.keySet()) {
            item = ItemManager.getItemBlock(key);
            reg.register((IForgeRegistryEntry)item);
        }
    }

    public static Block getBlock(String name) {
        return blockMap.get(name);
    }

    public static Item getItem(String name) {
        return itemMap.get(name);
    }

    public static ItemBlock getItemBlock(String name) {
        return itemBlockMap.get(name);
    }

    static {
        ItemManager.addBlock("vacant", (Block)new BlockVillager());
        ItemManager.addBlock("trader", (Block)new BlockVillagerTrader());
        ItemManager.addItem("wand", new ItemWand());
    }
}

