/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.block;

import alice.cubicvillager.CubicVillager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public class BlockVillager
extends BlockHorizontal {
    public final Logger LOG = CubicVillager.LOG;
    public static int tickIdleSound = 10;
    public static int chanceIdleSound = 500;
    public static final SoundEvent IDLE_SOUND_EVENT = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(370);

    public BlockVillager() {
        this("villager_block_n", false);
    }

    protected BlockVillager(String name, boolean isTileEntity) {
        super(Material.field_151575_d);
        this.func_149649_H();
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.func_176203_a(1));
        this.func_149711_c(1.4f);
        this.setRegistryName(name);
        this.func_149663_c(name);
    }

    public Item func_180660_a(IBlockState state, Random random, int par3) {
        return super.func_180660_a(state, random, par3);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), -1);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        IBlockState directionState;
        double yaw = Math.floor((double)(entity.field_70177_z / 360.0f * 4.0f) + 0.5);
        byte direction = (byte)((int)yaw & 3);
        switch (direction) {
            case 0: {
                directionState = this.func_176203_a(2);
                break;
            }
            case 1: {
                directionState = this.func_176203_a(3);
                break;
            }
            case 2: {
                directionState = this.func_176203_a(0);
                break;
            }
            case 3: {
                directionState = this.func_176203_a(1);
                break;
            }
            default: {
                directionState = this.func_176223_P();
            }
        }
        world.func_180501_a(pos, directionState, 2);
    }

    public int func_149738_a(World world) {
        return tickIdleSound;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        try {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
        catch (StackOverflowError e) {
            this.LOG.warn("Oh\u2026 StackOverflowError\u2026");
        }
        if (chanceIdleSound < 0) {
            return;
        }
        if (random.nextInt(chanceIdleSound) == 0) {
            world.func_184133_a(null, pos, IDLE_SOUND_EVENT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }
}

