/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.client;

import alice.cubicvillager.CommonProxy;
import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.ItemManager;
import alice.cubicvillager.client.ClientGuiHandler;
import alice.cubicvillager.client.renderer.tileentity.TileEntityVillagerBlockRenderer;
import alice.cubicvillager.tileentity.TileEntityVillager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ClientProxy
extends CommonProxy {
    private final TileEntityVillagerBlockRenderer renderVillagerTile = new TileEntityVillagerBlockRenderer();

    public ClientProxy() {
        this.guiHandler = new ClientGuiHandler();
    }

    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVillager.class, (TileEntitySpecialRenderer)this.renderVillagerTile);
    }

    @Override
    public void doRegisterModels() {
        super.doRegisterModels();
        this.setItemModel("wand");
        this.setBlockModel("vacant");
        this.setBlockModel("trader");
    }

    private void setItemModel(String name) {
        Item item = ItemManager.getItem(name);
        ResourceLocation res = item.getRegistryName();
        CubicVillager.LOG.info(res.toString());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(res, "inventory"));
    }

    private void setBlockModel(String name) {
        Block block = ItemManager.getBlock(name);
        ItemBlock item = ItemManager.getItemBlock(name);
        ResourceLocation res = block.getRegistryName();
        CubicVillager.LOG.info(res.toString());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(res, "inventory"));
    }
}

