/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.client.gui;

import alice.cubicvillager.CommonProxy;
import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.client.gui.MerchantButton;
import alice.cubicvillager.inventory.ContainerAutoMerchant;
import alice.cubicvillager.network.ChangeTradeMessage;
import alice.cubicvillager.tileentity.TileEntityVillager;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiAutoMerchant
extends GuiContainer {
    private SimpleNetworkWrapper netWrapper;
    private static final ResourceLocation guiTrading = new ResourceLocation("cubicvillager", "textures/gui/container/villager.png");
    private TileEntityVillager villager;
    private MerchantButton nextRecipeButtonIndex;
    private MerchantButton previousRecipeButtonIndex;
    private String guiCaption;
    private String inventoryCaption;
    private int currentRecipeIndex;
    private int xCenter;
    private int yCenter;

    public GuiAutoMerchant(InventoryPlayer playerInventory, TileEntityVillager _villager, World world) {
        super((Container)new ContainerAutoMerchant(playerInventory, _villager, world));
        this.currentRecipeIndex = _villager.getTradeIndex();
        this.villager = _villager;
        this.guiCaption = I18n.func_135052_a((String)"container.villager_block", (Object[])new Object[0]);
        this.inventoryCaption = I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]);
        this.field_147000_g = 200;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.nextRecipeButtonIndex) {
            ++this.currentRecipeIndex;
        } else if (button == this.previousRecipeButtonIndex) {
            --this.currentRecipeIndex;
        }
        this.villager.setTradeIndex(this.currentRecipeIndex);
        this.netWrapper.sendToServer((IMessage)new ChangeTradeMessage(this.villager, this.currentRecipeIndex));
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glPushAttrib((int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiTrading);
        this.func_73729_b(this.xCenter, this.yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPopAttrib();
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(this.guiCaption, (this.field_146999_f - this.field_146289_q.func_78256_a(this.guiCaption)) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.inventoryCaption, 8, this.field_147000_g - 94, 0x404040);
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)24640);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        super.func_73863_a(x, y, par3);
        this.func_191948_b(x, y);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        boolean noTrade = this.villager.isEmptyTrades();
        if (noTrade) {
            RenderHelper.func_74519_b();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            return;
        }
        MerchantRecipe recipe = this.villager.getCurrentTrade();
        ItemStack[] slot = new ItemStack[]{recipe.func_77394_a(), recipe.func_77396_b(), recipe.func_77397_d()};
        this.field_146296_j.field_77023_b = 100.0f;
        this.field_146296_j.func_180450_b(slot[0], this.xCenter + 36, this.yCenter + 24);
        this.field_146296_j.func_180453_a(this.field_146289_q, slot[0], this.xCenter + 36, this.yCenter + 24, null);
        if (slot[1] != null) {
            this.field_146296_j.func_180450_b(slot[1], this.xCenter + 62, this.yCenter + 24);
            this.field_146296_j.func_180453_a(this.field_146289_q, slot[1], this.xCenter + 62, this.yCenter + 24, null);
        }
        this.field_146296_j.func_180450_b(slot[2], this.xCenter + 120, this.yCenter + 24);
        this.field_146296_j.func_180453_a(this.field_146289_q, slot[2], this.xCenter + 120, this.yCenter + 24, null);
        this.field_146296_j.field_77023_b = 0.0f;
        if (this.func_146978_c(36, 24, 16, 16, x, y)) {
            this.func_146285_a(slot[0], x, y);
        } else if (slot[1] != null && this.func_146978_c(62, 24, 16, 16, x, y)) {
            this.func_146285_a(slot[1], x, y);
        } else if (this.func_146978_c(120, 24, 16, 16, x, y)) {
            this.func_146285_a(slot[2], x, y);
        }
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        CommonProxy proxy = CubicVillager.getProxy();
        this.netWrapper = proxy.simpleNetWrapper;
        this.xCenter = (this.field_146294_l - this.field_146999_f) / 2;
        this.yCenter = (this.field_146295_m - this.field_147000_g) / 2;
        this.nextRecipeButtonIndex = new MerchantButton(1, this.xCenter + 147, this.yCenter + 23, true);
        this.previousRecipeButtonIndex = new MerchantButton(2, this.xCenter + 17, this.yCenter + 23, false);
        this.field_146292_n.add(this.nextRecipeButtonIndex);
        this.field_146292_n.add(this.previousRecipeButtonIndex);
        this.nextRecipeButtonIndex.field_146124_l = false;
        this.previousRecipeButtonIndex.field_146124_l = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        MerchantRecipeList merchantrecipelist = this.villager.getTrades();
        if (merchantrecipelist != null) {
            this.nextRecipeButtonIndex.field_146124_l = this.currentRecipeIndex < merchantrecipelist.size() - 1;
            this.previousRecipeButtonIndex.field_146124_l = this.currentRecipeIndex > 0;
        }
        this.currentRecipeIndex = this.villager.getTradeIndex();
    }
}

