/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.item;

import alice.cubicvillager.CubicVillager;
import alice.cubicvillager.ItemManager;
import alice.cubicvillager.utility.VillagerData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemWand
extends Item {
    public ItemWand() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77664_n();
        this.func_77656_e(42);
        this.func_77625_d(1);
        this.setRegistryName("villager_wand");
        this.func_77655_b("villager_wand");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (playerIn.field_71075_bZ.field_75098_d) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        int invSize = playerIn.field_71071_by.func_70302_i_();
        for (int index = 0; index < invSize; ++index) {
            ItemStack item = playerIn.field_71071_by.func_70301_a(index);
            if (item == ItemStack.field_190927_a || item.func_77973_b() != Items.field_151166_bC || item.func_190916_E() <= 0) continue;
            int itemDamage = itemStackIn.func_77952_i();
            if (itemDamage <= 0) break;
            playerIn.field_71071_by.func_70298_a(index, 1);
            if ((itemDamage -= 21) < 0) {
                itemDamage = 0;
            }
            itemStackIn.func_77964_b(itemDamage);
            break;
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int damage;
        ItemStack itemStack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (!ItemWand.isVillagerBlock(world, pos)) {
            return EnumActionResult.PASS;
        }
        if (player.field_71075_bZ.field_75098_d) {
            player.openGui((Object)CubicVillager.me, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        if (!player.field_71075_bZ.field_75098_d && (damage = 2 + itemStack.func_77952_i()) > itemStack.func_77958_k()) {
            return EnumActionResult.FAIL;
        }
        IBlockState villagerBlock = world.func_180495_p(pos);
        Block vb = villagerBlock.func_177230_c();
        vb.func_176208_a(world, pos, villagerBlock, player);
        world.func_175655_b(pos, false);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_77964_b(itemStack.func_77952_i() + 2);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityZombie) {
            return this.doZombie(itemStack, player, (EntityZombie)entity);
        }
        if (entity instanceof EntityVillager) {
            return this.doVillager(itemStack, player, (EntityVillager)entity);
        }
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return ItemWand.isVillagerBlock((World)world, pos);
    }

    protected static boolean isVillagerBlock(World world, BlockPos pos) {
        Block villagerBlock = ItemManager.getBlock("trader");
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_177230_c() == villagerBlock;
    }

    private boolean doZombieVillager(ItemStack itemStack, EntityPlayer player, EntityZombieVillager entity) {
        if (!player.field_70170_p.field_72995_K) {
            return false;
        }
        boolean power = false;
        int emeraldAt = -1;
        int appleAt = -1;
        InventoryPlayer inv = player.field_71071_by;
        if (player.field_71075_bZ.field_75098_d) {
            power = true;
        } else {
            int invElements = inv.func_70302_i_();
            for (int i = 0; i < invElements; ++i) {
                Item item;
                ItemStack stack = inv.func_70301_a(i);
                if (stack == ItemStack.field_190927_a || (item = stack.func_77973_b()) != Items.field_151153_ao || appleAt != -1) continue;
                if (stack.func_77952_i() == 0) {
                    appleAt = i;
                    continue;
                }
                if (item != Items.field_151166_bC || emeraldAt != -1) continue;
                emeraldAt = i;
            }
            if (appleAt == -1) {
                return false;
            }
            if (emeraldAt == -1) {
                int damage = itemStack.func_77952_i();
                int maxDamage = itemStack.func_77958_k();
                if ((damage += 21) <= maxDamage) {
                    itemStack.func_77964_b(damage);
                    power = true;
                }
            } else {
                power = true;
            }
        }
        if (!power) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            inv.func_70298_a(appleAt, 1);
            inv.func_70298_a(emeraldAt, 1);
        }
        entity.func_191991_a(player.func_110124_au(), 1);
        return true;
    }

    private boolean doZombie(ItemStack itemStack, EntityPlayer player, EntityZombie entity) {
        if (entity instanceof EntityZombieVillager) {
            return this.doZombieVillager(itemStack, player, (EntityZombieVillager)entity);
        }
        return false;
    }

    private boolean doVillager(ItemStack itemStack, EntityPlayer player, EntityVillager entity) {
        if (!player.field_70170_p.field_72995_K) {
            int damage;
            if (!player.field_71075_bZ.field_75098_d && (damage = 1 + itemStack.func_77952_i()) > itemStack.func_77958_k()) {
                return false;
            }
            if (entity.func_70631_g_()) {
                entity.func_70873_a(1);
                entity.func_70636_d();
            }
            ItemStack newItemStack = new ItemStack(ItemManager.getBlock("trader"), 1, 0);
            NBTTagCompound tagItemStack = new NBTTagCompound();
            VillagerData.villagerToTag(entity, tagItemStack);
            newItemStack.func_77982_d(tagItemStack);
            EntityItem itemDrop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, newItemStack);
            player.field_70170_p.func_72838_d((Entity)itemDrop);
        }
        Random rng = entity.func_70681_au();
        for (int prof = 0; prof < 5; ++prof) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t - 0.5 + rng.nextDouble() * 2.0, entity.field_70163_u - 0.5 + rng.nextDouble() * 2.0, entity.field_70161_v - 0.5 + rng.nextDouble() * 2.0, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!player.field_70170_p.field_72995_K) {
            entity.func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_77964_b(itemStack.func_77952_i() + 1);
            }
        }
        return true;
    }
}

