/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.network;

import alice.cubicvillager.TradeInfo;
import alice.cubicvillager.network.UpdateRecipeMode;
import alice.cubicvillager.tileentity.TileEntityVillager;
import alice.cubicvillager.utility.TypeTransformer;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class UpdateRecipeMessage
implements IMessage {
    private static final TradeInfo nullTrade = new TradeInfo();
    public UpdateRecipeMode mode;
    public int dimension;
    public int x;
    public int y;
    public int z;
    public int tradeIndex;
    public TradeInfo trade;

    public UpdateRecipeMessage() {
        this.trade = nullTrade;
    }

    public UpdateRecipeMessage(TileEntityVillager tile, UpdateRecipeMode mode, int recipeIndex, TradeInfo trade) {
        World w = tile.func_190670_t_();
        this.dimension = w.field_73011_w.getDimension();
        BlockPos p = tile.func_190671_u_();
        this.x = p.func_177958_n();
        this.y = p.func_177956_o();
        this.z = p.func_177952_p();
        this.mode = mode;
        this.tradeIndex = recipeIndex;
        this.trade = trade == null ? nullTrade : trade;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.mode = UpdateRecipeMode.fromNumber(TypeTransformer.fromUnsignedByte(buf.readByte()));
        this.tradeIndex = TypeTransformer.fromUnsignedShort(buf.readShort());
        this.trade.itemBuy[0] = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.trade.itemBuy[1] = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.trade.itemSell = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)TypeTransformer.toUnsignedByte(this.mode.toNumber()));
        buf.writeShort((int)TypeTransformer.toUnsignedShort(this.tradeIndex));
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.trade.itemBuy[0]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.trade.itemBuy[1]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.trade.itemSell);
    }
}

