/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.network;

import alice.cubicvillager.network.UpdateTradeClientMessage;
import alice.cubicvillager.tileentity.TileEntityVillager;
import alice.cubicvillager.utility.TypeTransformer;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class UpdateTradeMessage
implements IMessage,
IMessageHandler<UpdateTradeClientMessage, IMessage> {
    protected int dimension;
    protected BlockPos pos;
    protected int xCoord;
    protected int yCoord;
    protected int zCoord;
    protected int tradeIndex;

    public UpdateTradeMessage() {
    }

    public UpdateTradeMessage(TileEntityVillager tile) {
        World world = tile.func_190670_t_();
        this.dimension = world.field_73011_w.getDimension();
        this.pos = tile.func_190671_u_();
        this.xCoord = this.pos.func_177958_n();
        this.yCoord = this.pos.func_177956_o();
        this.zCoord = this.pos.func_177952_p();
        this.tradeIndex = tile.getTradeIndex();
    }

    protected void notifyupdateVillagerBlock() {
    }

    public IMessage onMessage(UpdateTradeClientMessage message, MessageContext ctx) {
        message.notifyupdateVillagerBlock();
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readShort();
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.tradeIndex = TypeTransformer.fromUnsignedByte(buf.readByte());
        this.pos = new BlockPos(this.xCoord, this.yCoord, this.zCoord);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.dimension);
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeByte((int)TypeTransformer.toUnsignedByte(this.tradeIndex));
    }
}

