/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.network.client;

import alice.cubicvillager.TradeInfo;
import alice.cubicvillager.utility.TypeTransformer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class RefreshTradesMessage
implements IMessage {
    public List<TradeInfo> tradeList = new ArrayList<TradeInfo>();

    public RefreshTradesMessage() {
    }

    public RefreshTradesMessage(List<TradeInfo> tradeList) {
        this.tradeList.addAll(tradeList);
    }

    public void fromBytes(ByteBuf buf) {
        int countTrades = TypeTransformer.fromUnsignedShort(buf.readShort());
        if (countTrades == 0) {
            return;
        }
        for (int i = 0; i < countTrades; ++i) {
            boolean noErr = true;
            ItemStack buyA = null;
            ItemStack buyB = null;
            ItemStack sell = null;
            try {
                buyA = ByteBufUtils.readItemStack((ByteBuf)buf);
                buyB = ByteBufUtils.readItemStack((ByteBuf)buf);
                sell = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            catch (Exception e) {
                noErr = false;
            }
            if (!noErr) continue;
            TradeInfo info = new TradeInfo();
            info.itemBuy[0] = buyA;
            info.itemBuy[1] = buyB;
            info.itemSell = sell;
            this.tradeList.add(info);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)TypeTransformer.toUnsignedShort(this.tradeList.size()));
        for (TradeInfo info : this.tradeList) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)info.itemBuy[0]);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)info.itemBuy[1]);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)info.itemSell);
        }
    }
}

