/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.network.client;

import alice.cubicvillager.TradeInfo;
import alice.cubicvillager.inventory.ContainerMerchantEditor;
import alice.cubicvillager.utility.TypeTransformer;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ResultLoadTradeMessage
implements IMessage {
    public int trades;
    public int tradeIndex;
    public TradeInfo tradeInfo;

    public ResultLoadTradeMessage() {
    }

    public ResultLoadTradeMessage(ContainerMerchantEditor container) {
        this.trades = container.getNumberOfTrades();
        this.tradeIndex = container.getCurrentTradeIndex();
        this.tradeInfo = container.getCurrentTrade();
    }

    public void fromBytes(ByteBuf buf) {
        this.trades = TypeTransformer.fromUnsignedShort(buf.readShort());
        this.tradeIndex = TypeTransformer.fromUnsignedShort(buf.readShort());
        this.tradeInfo.itemBuy[0] = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.tradeInfo.itemBuy[1] = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.tradeInfo.itemSell = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)TypeTransformer.toUnsignedShort(this.trades));
        buf.writeShort((int)TypeTransformer.toUnsignedShort(this.tradeIndex));
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.tradeInfo.itemBuy[0]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.tradeInfo.itemBuy[1]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.tradeInfo.itemSell);
    }
}

