/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.tileentity;

import alice.cubicvillager.utility.Trader;
import alice.cubicvillager.utility.VillagerData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.GameData;

public class TileEntityVillager
extends TileEntity
implements IMerchant,
ISidedInventory,
ITickable {
    protected static final RegistryNamespaced<ResourceLocation, VillagerRegistry.VillagerProfession> PROFESSIONS = GameData.getWrapper(VillagerRegistry.VillagerProfession.class);
    protected static final int[] accessibleIndexes = new int[]{0, 1, 2};
    protected MerchantRecipeList tradeList;
    protected static final MerchantRecipeList emptyTrades = new MerchantRecipeList();
    public final ItemStack[] tradeInventory = new ItemStack[3];
    public final ItemStack[] inventory = new ItemStack[8];
    protected final IItemHandler itemHandleUp = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    protected final IItemHandler itemHandleDown = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    protected final IItemHandler itemHandleNorth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    protected final IItemHandler itemHandleSouth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
    protected final IItemHandler itemHandleWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    protected final IItemHandler itemHandleEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    protected VillagerRegistry.VillagerProfession vp;
    protected String profession;
    protected int career;
    public int love;
    protected int tradeIndex;
    private AxisAlignedBB updateRange;
    private BlockPos updateRangeCenter;
    private String name;
    private boolean noTrade;

    public TileEntityVillager() {
    }

    public TileEntityVillager(World world) {
        int i;
        this.field_145850_b = world;
        EntityVillager dummyVillager = new EntityVillager(world);
        VillagerRegistry.setRandomProfession((EntityVillager)dummyVillager, (Random)dummyVillager.func_70681_au());
        this.profession = dummyVillager.getProfessionForge().getRegistryName().toString();
        this.career = dummyVillager.field_175563_bv;
        this.love = dummyVillager.field_175562_bw;
        this.tradeList = dummyVillager.func_70934_b(null);
        for (i = 0; i < 3; ++i) {
            this.tradeInventory[i] = ItemStack.field_190927_a;
        }
        for (i = 0; i < 8; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    public World func_190670_t_() {
        return this.field_145850_b;
    }

    public BlockPos func_190671_u_() {
        return this.field_174879_c;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        VillagerData.tileToTagWithItems(this, tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        VillagerData.tileToTagWithItems(this, tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag;
        if (pkt.func_179823_a().equals((Object)this.field_174879_c) && pkt.func_148853_f() == 1 && (tag = pkt.func_148857_g()) != null) {
            VillagerData.tagToTile(tag, this);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler cap;
            switch (facing) {
                case UP: {
                    cap = this.itemHandleUp;
                    break;
                }
                case DOWN: {
                    cap = this.itemHandleDown;
                    break;
                }
                case NORTH: {
                    cap = this.itemHandleNorth;
                    break;
                }
                case SOUTH: {
                    cap = this.itemHandleSouth;
                    break;
                }
                case WEST: {
                    cap = this.itemHandleWest;
                    break;
                }
                case EAST: {
                    cap = this.itemHandleEast;
                    break;
                }
                default: {
                    cap = null;
                }
            }
            return (T)cap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setProfession(String profession) {
        this.vp = (VillagerRegistry.VillagerProfession)PROFESSIONS.func_82594_a((Object)new ResourceLocation(profession));
        this.profession = profession;
    }

    public String getProfession() {
        return this.profession;
    }

    public void setCareer(int career) {
        this.career = career;
    }

    public int getCareer() {
        return this.career;
    }

    public MerchantRecipeList getTrades() {
        return this.tradeList;
    }

    public void setTrades(MerchantRecipeList tradeList) {
        if (tradeList == null || tradeList.size() == 0) {
            this.setNoTrades();
        } else {
            this.noTrade = false;
            this.tradeList = tradeList;
            this.setTradeIndex(this.getTradeIndex());
        }
    }

    public void setNoTrades() {
        this.noTrade = true;
        this.tradeList = emptyTrades;
        this.tradeIndex = -1;
    }

    public boolean isEmptyTrades() {
        return this.noTrade;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            this.name = null;
        } else if (this.name == null || !this.name.equals(name)) {
            this.name = name;
        }
    }

    public MerchantRecipe getCurrentTrade() {
        if (this.noTrade) {
            return null;
        }
        return (MerchantRecipe)this.tradeList.get(this.tradeIndex);
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int index) {
        if (this.tradeList.size() == 0) {
            this.tradeIndex = -1;
            return;
        }
        if (index < 0) {
            index = 0;
        } else {
            int lastIndex = this.tradeList.size() - 1;
            if (index > lastIndex) {
                index = lastIndex;
            }
        }
        this.tradeIndex = index;
    }

    public AxisAlignedBB getUpdateRange() {
        if (this.updateRange == null || this.field_174879_c.equals((Object)this.updateRangeCenter)) {
            this.updateRange();
        }
        return this.updateRange;
    }

    private void updateRange() {
        double oX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double oY = (double)this.field_174879_c.func_177956_o() + 0.5;
        double oZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.updateRange = new AxisAlignedBB(oX - 8.0, oY - 8.0, oZ - 8.0, oX + 8.0, oY + 8.0, oZ + 8.0);
        this.updateRangeCenter = this.field_174879_c;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        VillagerData.tagToTile(tagCompound, this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        VillagerData.tileToTagWithItems(this, tagCompound);
        return tagCompound;
    }

    public void func_73660_a() {
        if (emptyTrades.size() > 0) {
            throw new IllegalStateException("emptyTrades\u306f\u7a7a\u30ea\u30b9\u30c8\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tradeList.size() == 0) {
            return;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        MerchantRecipe r = (MerchantRecipe)this.tradeList.get(this.tradeIndex);
        if (!this.tradeInventory[2].func_190926_b() && !Trader.isItemStackable(this.tradeInventory[2], r.field_77402_c)) {
            return;
        }
        ItemStack result = Trader.doTrade(r, this.tradeInventory[0], this.tradeInventory[1], this.tradeInventory[2]);
        if (!result.func_190926_b()) {
            this.tradeInventory[2] = result;
            if (this.tradeInventory[0].func_190926_b()) {
                this.tradeInventory[0] = ItemStack.field_190927_a;
            }
            if (this.tradeInventory[1].func_190926_b()) {
                this.tradeInventory[1] = ItemStack.field_190927_a;
            }
        }
    }

    public int func_70302_i_() {
        return this.tradeInventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return ItemStack.field_190927_a;
        }
        return this.tradeInventory[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return null;
        }
        if (this.tradeInventory[index].func_190926_b()) {
            return null;
        }
        if (this.tradeInventory[index].func_190916_E() <= amount) {
            ItemStack itemstack = this.tradeInventory[index];
            this.tradeInventory[index] = ItemStack.field_190927_a;
            return itemstack;
        }
        ItemStack itemstack = this.tradeInventory[index].func_77979_a(amount);
        if (this.tradeInventory[index].func_190926_b()) {
            this.tradeInventory[index] = ItemStack.field_190927_a;
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (index < 0 || index >= this.tradeInventory.length) {
            return;
        }
        this.tradeInventory[index] = itemStack;
        int limit = this.func_70297_j_();
        if (itemStack != ItemStack.field_190927_a && itemStack.func_190916_E() > limit) {
            itemStack.func_190920_e(limit);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        double zCoord;
        double yCoord;
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double xCoord = (double)this.field_174879_c.func_177958_n() + 0.5;
        return !(player.func_70092_e(xCoord, yCoord = (double)this.field_174879_c.func_177956_o() + 0.5, zCoord = (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return accessibleIndexes;
    }

    public boolean func_180462_a(int index, ItemStack itemStack, EnumFacing direction) {
        return index != 2;
    }

    public boolean func_180461_b(int index, ItemStack itemstack, EnumFacing direction) {
        return index == 2;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack item = this.func_70301_a(index);
        if (!item.func_190926_b()) {
            this.tradeInventory[index] = ItemStack.field_190927_a;
        }
        return item;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        int isize = this.func_70302_i_();
        for (int i = 0; i < isize; ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70932_a_(EntityPlayer player) {
    }

    public EntityPlayer func_70931_l_() {
        return null;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        return this.tradeList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
    }

    public void func_110297_a_(ItemStack stack) {
    }
}

