/*
 * Decompiled with CFR 0.152.
 */
package alice.cubicvillager.utility;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class TypeTransformer {
    public static int fromUnsignedByte(byte value) {
        if (value >= 0) {
            return value;
        }
        return value + 256;
    }

    public static byte toUnsignedByte(int value) {
        if (value < 0) {
            return 0;
        }
        if (value >= 128) {
            if (value >= 256) {
                return -1;
            }
            return (byte)(value - 256);
        }
        return (byte)value;
    }

    public static int fromUnsignedShort(short value) {
        if (value >= 0) {
            return value;
        }
        return value + 32768;
    }

    public static short toUnsignedShort(int value) {
        if (value < 0) {
            return 0;
        }
        if (value >= 32768) {
            if (value >= 65536) {
                return -1;
            }
            return (short)(value - 32768);
        }
        return (short)value;
    }

    public static byte[] toBytes(UUID id) {
        long l = id.getLeastSignificantBits();
        long m = id.getMostSignificantBits();
        byte[] raw = new byte[16];
        for (int i = 0; i < 8; ++i) {
            raw[i] = TypeTransformer.toUnsignedByte((int)(l & 0xFFL));
            raw[8 + i] = TypeTransformer.toUnsignedByte((int)(m & 0xFFL));
            l >>= 8;
            m >>= 8;
        }
        return raw;
    }

    public static byte[] md5(byte[] bin) {
        MessageDigest dig;
        try {
            dig = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            dig = null;
        }
        if (dig == null) {
            return new byte[16];
        }
        dig.update(bin);
        return dig.digest();
    }
}

