/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.block;

import a1lic.cubicvillager.block.VillagerBlock;
import a1lic.cubicvillager.client.render.tileentity.TraderTileEntityRenderer;
import a1lic.cubicvillager.event.RegistryHandler;
import a1lic.cubicvillager.tileentity.TraderTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public final class TraderBlock
extends VillagerBlock {
    private static final String REGNAME = "cubic_villager";
    private static final ResourceLocation RESLOC = new ResourceLocation("cubicvillager", "cubic_villager");
    private static final Block.Properties PROPERTY = Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151650_B);
    private static final Item.Properties PROPERTY_ITEM;
    private final BlockItem BLOCKITEM;
    private final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.0, (double)0.1, (double)0.9, (double)1.0, (double)0.9);

    public TraderBlock() {
        super(0);
        this.setRegistryName(RESLOC);
        BlockState state = (BlockState)this.field_176227_L.func_177621_b();
        state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH);
        this.func_180632_j(state);
        this.BLOCKITEM = new BlockItem((Block)this, PROPERTY_ITEM);
        this.BLOCKITEM.setRegistryName(RESLOC);
    }

    @Override
    public BlockItem getBlockItem() {
        return this.BLOCKITEM;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean keepData;
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (!(te instanceof TraderTileEntity)) {
            return Collections.EMPTY_LIST;
        }
        ItemStack drop = new ItemStack((IItemProvider)this);
        Entity entity = (Entity)builder.func_216019_b(LootParameters.field_216281_a);
        if (entity instanceof PlayerEntity) {
            boolean notWand;
            ItemStack chk = ((LivingEntity)entity).func_184586_b(Hand.MAIN_HAND);
            if (chk.func_190926_b()) {
                chk = ((LivingEntity)entity).func_184586_b(Hand.OFF_HAND);
            }
            if (chk.func_190926_b()) {
                notWand = true;
            } else {
                Item item = chk.func_77973_b();
                boolean bl = notWand = item != RegistryHandler.itemVillagerWand;
            }
            keepData = notWand ? ((PlayerEntity)entity).func_226563_dT_() : true;
        } else {
            keepData = false;
        }
        if (keepData) {
            CompoundNBT tag = drop.func_196082_o();
            ((TraderTileEntity)te).writeMetadatas(tag, true);
            ((TraderTileEntity)te).func_174888_l();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        list.add(drop);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String regPath;
        String regNamespace;
        ResourceLocation regname;
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b("Type")) {
            String typeString = tag.func_74779_i("Type");
            regname = new ResourceLocation(typeString);
            regNamespace = regname.func_110624_b();
            regPath = regname.func_110623_a();
            typeString = String.format("biome.%s.%s", regNamespace, regPath);
            typeString = I18n.func_135052_a((String)typeString, (Object[])new Object[0]);
            TranslationTextComponent typeTip = new TranslationTextComponent("item.cubicvillager.type", new Object[]{typeString});
            tooltip.add((ITextComponent)typeTip);
        }
        if (tag.func_74764_b("Prof")) {
            String profString = tag.func_74779_i("Prof");
            regname = new ResourceLocation(profString);
            regNamespace = regname.func_110624_b();
            regPath = regname.func_110623_a();
            profString = String.format("entity.%s.villager.%s", regNamespace, regPath);
            profString = I18n.func_135052_a((String)profString, (Object[])new Object[0]);
            TranslationTextComponent profTip = new TranslationTextComponent("item.cubicvillager.profession", new Object[]{profString});
            tooltip.add((ITextComponent)profTip);
        }
        if (tag.func_74764_b("Exp")) {
            int next;
            int level;
            int exp = tag.func_74762_e("Exp");
            if (exp < 10) {
                level = 1;
                next = 10;
            } else if (exp < 70) {
                level = 2;
                next = 70;
            } else if (exp < 150) {
                level = 3;
                next = 150;
            } else if (exp < 250) {
                level = 4;
                next = 250;
            } else {
                level = 5;
                next = -1;
            }
            String levelString = String.format("merchant.level.%d", level);
            levelString = I18n.func_135052_a((String)levelString, (Object[])new Object[0]);
            TranslationTextComponent levelTip = new TranslationTextComponent("item.cubicvillager.level", new Object[]{levelString});
            tooltip.add((ITextComponent)levelTip);
            TranslationTextComponent expTip = next == -1 ? new TranslationTextComponent("item.cubicvillager.exp_nonext", new Object[]{exp}) : new TranslationTextComponent("item.cubicvillager.exp", new Object[]{exp, next});
            tooltip.add((ITextComponent)expTip);
        }
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        return te instanceof TraderTileEntity ? (TraderTileEntity)te : null;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult trace) {
        if (worldIn instanceof ServerWorld) {
            INamedContainerProvider prov;
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TraderTileEntity) {
                SUpdateTileEntityPacket pkt = tile.func_189518_D_();
                assert (pkt != null);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)pkt);
            }
            if ((prov = this.func_220052_b(state, worldIn, pos)) != null) {
                player.func_213829_a(prov);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        CompoundNBT tag;
        if (!(worldIn instanceof ServerWorld)) {
            return;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TraderTileEntity)) {
            return;
        }
        if (!stack.func_190926_b() && (tag = stack.func_77978_p()) != null) {
            ((TraderTileEntity)tileentity).readMetadatas(tag);
        }
        BlockPos pos1 = pos.func_177977_b();
        BlockPos pos2 = pos.func_177979_c(2);
        BlockState digDownState = worldIn.func_180495_p(pos1);
        Block block1 = digDownState.func_177230_c();
        digDownState = worldIn.func_180495_p(pos2);
        Block block2 = digDownState.func_177230_c();
        int emeraldCount = 0;
        boolean isEmerald = Tags.Blocks.STORAGE_BLOCKS_EMERALD.func_199685_a_((Object)block1);
        if (isEmerald) {
            ++emeraldCount;
        }
        if (isEmerald = Tags.Blocks.STORAGE_BLOCKS_EMERALD.func_199685_a_((Object)block2)) {
            ++emeraldCount;
        }
        if (emeraldCount != 2) {
            ((TraderTileEntity)tileentity).notifyUpdateToClient(true);
        } else {
            AbstractVillagerEntity villager = ((TraderTileEntity)tileentity).createVillagerEntity(-2);
            worldIn.func_217376_c((Entity)villager);
            boolean drop = placer instanceof PlayerEntity;
            if (drop) {
                drop = !((PlayerEntity)placer).func_184812_l_();
            }
            worldIn.func_175655_b(pos, false);
            worldIn.func_175655_b(pos1, drop);
            worldIn.func_175655_b(pos2, drop);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TraderTileEntity) {
            IInventory inventory = ((TraderTileEntity)tileentity).getTradeInventory();
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory);
        }
        if (tileentity != null) {
            worldIn.func_175713_t(pos);
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TraderTileEntity(world instanceof World ? (World)world : null);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    static {
        PROPERTY.func_200947_a(SoundType.field_185848_a);
        PROPERTY.func_200948_a(0.8f, 30.0f);
        PROPERTY_ITEM = new Item.Properties();
        PROPERTY_ITEM.func_200916_a(RegistryHandler.CREATIVE_TAB);
        PROPERTY_ITEM.setISTER(() -> TraderTileEntityRenderer.ISTER::new);
    }
}

