/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.block;

import a1lic.cubicvillager.block.IBlockItem;
import a1lic.cubicvillager.event.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.storage.loot.LootContext;

public class VillagerSlabBlock
extends Block
implements IBlockItem {
    private static final String REGNAME = "villager_slab";
    private static final ResourceLocation RESLOC = new ResourceLocation("cubicvillager", "villager_slab");
    private static final Block.Properties PROPERTY;
    private static final Item.Properties PROPERTY_ITEM;
    private final BlockItem BLOCKITEM;
    private static final DirectionProperty ATTACH;
    private static final DirectionProperty FACE;
    private static final VoxelShape BOTTOM_SHAPE;
    private static final VoxelShape TOP_SHAPE;
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape SOUTH_SHAPE;
    private static final VoxelShape WEST_SHAPE;
    private static final VoxelShape EAST_SHAPE;
    private static final VoxelShape FULL_CUBE;

    public VillagerSlabBlock() {
        super(PROPERTY);
        this.setRegistryName(RESLOC);
        BlockState state = (BlockState)this.field_176227_L.func_177621_b();
        state = (BlockState)state.func_206870_a((IProperty)ATTACH, (Comparable)Direction.DOWN);
        state = (BlockState)state.func_206870_a((IProperty)FACE, (Comparable)Direction.NORTH);
        this.func_180632_j(state);
        this.BLOCKITEM = new BlockItem((Block)this, PROPERTY_ITEM);
        this.BLOCKITEM.setRegistryName(RESLOC);
    }

    @Override
    public BlockItem getBlockItem() {
        return this.BLOCKITEM;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ATTACH});
        builder.func_206894_a(new IProperty[]{FACE});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(1);
        ItemStack drop = new ItemStack((IItemProvider)this);
        stacks.add(drop);
        return stacks;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape;
        Direction attach = (Direction)state.func_177229_b((IProperty)ATTACH);
        Direction face = (Direction)state.func_177229_b((IProperty)FACE);
        block0 : switch (attach) {
            case DOWN: {
                shape = BOTTOM_SHAPE;
                break;
            }
            case UP: {
                shape = TOP_SHAPE;
                break;
            }
            case NORTH: {
                shape = NORTH_SHAPE;
                break;
            }
            case SOUTH: {
                shape = SOUTH_SHAPE;
                break;
            }
            case WEST: {
                switch (face) {
                    case NORTH: {
                        shape = EAST_SHAPE;
                        break block0;
                    }
                    case EAST: {
                        shape = SOUTH_SHAPE;
                        break block0;
                    }
                    case SOUTH: {
                        shape = WEST_SHAPE;
                        break block0;
                    }
                    case WEST: {
                        shape = NORTH_SHAPE;
                        break block0;
                    }
                }
                shape = FULL_CUBE;
                break;
            }
            case EAST: {
                switch (face) {
                    case NORTH: {
                        shape = WEST_SHAPE;
                        break block0;
                    }
                    case EAST: {
                        shape = NORTH_SHAPE;
                        break block0;
                    }
                    case SOUTH: {
                        shape = EAST_SHAPE;
                        break block0;
                    }
                    case WEST: {
                        shape = SOUTH_SHAPE;
                        break block0;
                    }
                }
                shape = FULL_CUBE;
                break;
            }
            default: {
                shape = FULL_CUBE;
            }
        }
        return shape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction attachs = context.func_196000_l();
        Direction dir = context.func_195992_f();
        dir = dir.func_176734_d();
        BlockState state = this.func_176223_P();
        state = (BlockState)state.func_206870_a((IProperty)FACE, (Comparable)dir);
        if (attachs == Direction.DOWN) {
            state = (BlockState)state.func_206870_a((IProperty)ATTACH, (Comparable)Direction.UP);
        } else if (attachs == Direction.UP) {
            state = (BlockState)state.func_206870_a((IProperty)ATTACH, (Comparable)Direction.DOWN);
        } else {
            double x;
            Vec3d vec = context.func_221532_j();
            BlockPos pos = context.func_195995_a();
            double y = 0.5 - (vec.field_72448_b - (double)pos.func_177956_o());
            if (attachs == Direction.NORTH) {
                x = 0.5 - (vec.field_72450_a - (double)pos.func_177958_n());
            } else if (attachs == Direction.SOUTH) {
                x = vec.field_72450_a - (double)pos.func_177958_n() - 0.5;
            } else if (attachs == Direction.WEST) {
                x = vec.field_72449_c - (double)pos.func_177952_p() - 0.5;
            } else if (attachs == Direction.EAST) {
                x = 0.5 - (vec.field_72449_c - (double)pos.func_177952_p());
            } else {
                throw new IllegalStateException("Invalid ATTACH property value!");
            }
            attachs = x >= 0.0 ? (y >= 0.0 ? (x > y ? Direction.EAST : Direction.WEST) : (x > -y ? Direction.EAST : Direction.UP)) : (y >= 0.0 ? (-x > y ? Direction.WEST : Direction.DOWN) : (-x > -y ? Direction.WEST : Direction.UP));
            state = (BlockState)state.func_206870_a((IProperty)ATTACH, (Comparable)attachs);
        }
        return state;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    static {
        ATTACH = DirectionProperty.func_196962_a((String)"attach", (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST});
        FACE = DirectionProperty.func_177712_a((String)"face", (Predicate)Direction.Plane.HORIZONTAL);
        BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        EAST_SHAPE = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        FULL_CUBE = VoxelShapes.func_197868_b();
        PROPERTY = Block.Properties.func_200949_a((Material)Material.field_215711_w, (MaterialColor)MaterialColor.field_151650_B);
        PROPERTY.func_200947_a(SoundType.field_185848_a);
        PROPERTY.func_200948_a(0.8f, 30.0f);
        PROPERTY_ITEM = new Item.Properties();
        PROPERTY_ITEM.func_200916_a(RegistryHandler.CREATIVE_TAB);
    }
}

