/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.client.gui.screen.inventory;

import a1lic.cubicvillager.inventory.container.TraderContainer;
import a1lic.cubicvillager.network.TradeIndexMessage;
import a1lic.cubicvillager.tileentity.TraderTileEntity;
import a1lic.cubicvillager.tool.network.PacketTool;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TraderScreen
extends ContainerScreen<TraderContainer> {
    private static final ResourceLocation TRADER_SCREEN = new ResourceLocation("cubicvillager", "textures/gui/container/trader_block.png");
    private final String traderTitle = I18n.func_135052_a((String)"container.cubicvillager.trader", (Object[])new Object[0]);
    private final String traderSelect = I18n.func_135052_a((String)"container.cubicvillager.tradersel", (Object[])new Object[0]);
    private final String traderInventory = I18n.func_135052_a((String)"container.cubicvillager.traderinv", (Object[])new Object[0]);
    private final String playerInventory = I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]);
    private final String maxLevel = I18n.func_135052_a((String)"container.cubicvillager.maxlv", (Object[])new Object[0]);
    private final String profession;
    private final String[] levelNames = new String[5];
    private final TraderTileEntity trader;
    private final List<TradeButton> buttons = new ArrayList<TradeButton>(7);
    private TextureManager manager;
    private int selectedIndex;
    private int topIndex;
    private boolean inDrag;
    private int levelRankTick;
    private long lastRenderedTick;
    private int cachedExpValue = -1;
    private String cachedNextLevel;

    public TraderScreen(TraderContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.trader = screenContainer.trader;
        if (this.trader.isRegularVillager) {
            ResourceLocation regname = this.trader.villagerProfession.getRegistryName();
            assert (regname != null);
            String regNamespace = regname.func_110624_b();
            String regPath = regname.func_110623_a();
            String profession = String.format("entity.%s.villager.%s", regNamespace, regPath);
            this.profession = I18n.func_135052_a((String)profession, (Object[])new Object[0]);
        } else {
            this.profession = I18n.func_135052_a((String)"entity.minecraft.wandering_trader", (Object[])new Object[0]);
        }
        for (int levelNum = 0; levelNum < 5; ++levelNum) {
            String levelName = String.format("merchant.level.%d", 1 + levelNum);
            this.levelNames[levelNum] = I18n.func_135052_a((String)levelName, (Object[])new Object[0]);
        }
        this.field_146999_f = 276;
    }

    private void drawFirstItem(ItemStack discountItem, ItemStack normalItem, int x, int y) {
        this.itemRenderer.func_180450_b(discountItem, x, y);
        if (normalItem.func_190916_E() == discountItem.func_190916_E()) {
            this.itemRenderer.func_175030_a(this.font, discountItem, x, y);
        } else {
            int count = normalItem.func_190916_E();
            if (count == 1) {
                this.itemRenderer.func_180453_a(this.font, normalItem, x, y, "1");
            }
            if ((count = discountItem.func_190916_E()) == 1) {
                this.itemRenderer.func_180453_a(this.font, discountItem, x + 14, y, "1");
            }
            this.manager.func_110577_a(TRADER_SCREEN);
            int offset = this.getBlitOffset();
            this.setBlitOffset(offset + 300);
            TraderScreen.blit((int)(x + 7), (int)(y + 12), (int)(offset + 300), (float)0.0f, (float)176.0f, (int)9, (int)2, (int)256, (int)512);
            this.setBlitOffset(offset);
        }
    }

    private void drawNotAvaiable(MerchantOffer offer, int x, int y) {
        RenderSystem.enableBlend();
        this.manager.func_110577_a(TRADER_SCREEN);
        int offset = this.getBlitOffset();
        boolean notAvaiable = offer.func_222217_o();
        float srcX = notAvaiable ? 25.0f : 15.0f;
        TraderScreen.blit((int)(x + 5 + 35 + 20), (int)(y + 3), (int)offset, (float)srcX, (float)171.0f, (int)10, (int)9, (int)256, (int)512);
    }

    private void drawScrollbar(MerchantOffers offers) {
        int scrollTabY;
        int overflow = offers.size() - 6;
        int offset = this.getBlitOffset();
        if (overflow > 1) {
            int j = 139 - (27 + (overflow - 1) * 139 / overflow);
            int k = 1 + j / overflow + 139 / overflow;
            scrollTabY = Math.min(113, this.topIndex * k);
            if (this.topIndex == overflow - 1) {
                scrollTabY = 113;
            }
        } else {
            scrollTabY = 0;
        }
        TraderScreen.blit((int)(this.field_147003_i + 94), (int)(this.field_147009_r + 18 + scrollTabY), (int)offset, (float)0.0f, (float)199.0f, (int)6, (int)27, (int)256, (int)512);
    }

    private void handleTradeButton(Button button) {
        if (!(button instanceof TradeButton)) {
            return;
        }
        int newIndex = ((TradeButton)button).buttonIndex + this.topIndex;
        if (this.selectedIndex == newIndex) {
            newIndex = -1;
        }
        this.selectedIndex = newIndex;
        this.trader.setTradeIndex(this.selectedIndex);
        TradeIndexMessage msg = new TradeIndexMessage(this.trader, this.selectedIndex);
        PacketTool.CHANNEL.sendToServer((Object)msg);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.manager.func_110577_a(TRADER_SCREEN);
        int blitOffset = this.getBlitOffset();
        TraderScreen.blit((int)this.field_147003_i, (int)this.field_147009_r, (int)blitOffset, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int width = this.font.func_78256_a(this.traderTitle);
        this.font.func_211126_b(this.traderTitle, 107.0f + (float)((102 - width) / 2), 6.0f, 0);
        width = this.font.func_78256_a(this.traderSelect);
        this.font.func_211126_b(this.traderSelect, 4.0f + (float)((97 - width) / 2), 6.0f, 0);
        this.font.func_211126_b(this.traderInventory, 215.0f, 6.0f, 0);
        width = this.font.func_78256_a(this.profession);
        this.font.func_211126_b(this.profession, 107.0f + (float)((102 - width) / 2), 47.0f, 0);
        if (this.trader.isRegularVillager) {
            if (this.levelRankTick < 50) {
                int levelNum = this.trader.getVillagerLevelFromExp();
                if (levelNum < 1) {
                    levelNum = 1;
                } else if (levelNum > 5) {
                    levelNum = 5;
                }
                width = this.font.func_78256_a(this.levelNames[levelNum - 1]);
                this.font.func_211126_b(this.levelNames[levelNum - 1], 107.0f + (float)((102 - width) / 2), 57.0f, 0);
            } else {
                int currentExp = this.trader.villagerExp;
                int currentLevel = this.trader.getVillagerLevelFromExp();
                if (currentLevel >= 5) {
                    this.cachedNextLevel = this.maxLevel;
                } else if (currentExp != this.cachedExpValue) {
                    this.cachedExpValue = currentExp;
                    int leftToNext = this.trader.getVillagerLeftToNextLevel();
                    this.cachedNextLevel = I18n.func_135052_a((String)"container.cubicvillager.nextlv", (Object[])new Object[]{leftToNext});
                }
                width = this.font.func_78256_a(this.cachedNextLevel);
                this.font.func_211126_b(this.cachedNextLevel, 107.0f + (float)((102 - width) / 2), 57.0f, 0);
            }
        } else {
            width = this.font.func_78256_a(this.maxLevel);
            this.font.func_211126_b(this.maxLevel, 107.0f + (float)((102 - width) / 2), 57.0f, 0);
        }
        assert (this.minecraft != null && this.minecraft.field_71441_e != null);
        long currentTick = this.minecraft.field_71441_e.func_82737_E();
        if (currentTick > this.lastRenderedTick) {
            ++this.levelRankTick;
            if (this.levelRankTick >= 100) {
                this.levelRankTick = 0;
            }
            this.lastRenderedTick = currentTick;
        }
        this.font.func_211126_b(this.playerInventory, 107.0f, 73.0f, 0);
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.manager = this.minecraft.func_110434_K();
        int y = this.field_147009_r + 18;
        this.buttons.clear();
        this.selectedIndex = this.trader.getTradeIndex();
        for (int index = 0; index < 7; ++index) {
            TradeButton button = new TradeButton(this.field_147003_i + 5, y, index, this::handleTradeButton);
            this.buttons.add(button);
            y += 20;
        }
        for (TradeButton button : this.buttons) {
            this.addButton((Widget)button);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_mouseClicked_5_) {
        this.inDrag = false;
        MerchantOffers offers = this.trader.villagerOffers;
        int offerCount = offers.size();
        if (offerCount > 7) {
            double hitboxLeft = this.field_147003_i + 94;
            double hitboxRight = (int)hitboxLeft + 6;
            double hitboxTop = this.field_147009_r + 18;
            double hitboxBottom = (int)hitboxTop + 140;
            if (mouseX > hitboxLeft && mouseX < hitboxRight && mouseY > hitboxTop && mouseY <= hitboxBottom) {
                this.inDrag = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, p_mouseClicked_5_);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int activeButton, double raitoX, double raitoY) {
        if (!this.inDrag) {
            return super.mouseDragged(mouseX, mouseY, activeButton, raitoX, raitoY);
        }
        MerchantOffers offers = this.trader.villagerOffers;
        int offerCount = offers.size();
        int hitboxTop = this.field_147009_r + 18;
        int hitboxBottom = hitboxTop + 139;
        float hitboxYRaito = ((float)mouseY - (float)hitboxTop - 13.5f) / ((float)(hitboxBottom - hitboxTop) - 27.0f);
        hitboxYRaito = hitboxYRaito * (float)offerCount + 0.5f;
        this.topIndex = MathHelper.func_76125_a((int)((int)hitboxYRaito), (int)0, (int)(offerCount - 7));
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        int size = this.trader.villagerOffers.size();
        if (size > 7) {
            int overflow = size - 7;
            this.topIndex = (int)((double)this.topIndex - scrollDelta);
            this.topIndex = MathHelper.func_76125_a((int)this.topIndex, (int)0, (int)overflow);
        }
        return true;
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        int nextAt;
        int level;
        int xp;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTick);
        this.manager.func_110577_a(TRADER_SCREEN);
        int blitOffset = this.getBlitOffset();
        int xpBarPosX = this.field_147003_i + 107;
        int xpBarPosY = this.field_147009_r + 66;
        TraderScreen.blit((int)xpBarPosX, (int)xpBarPosY, (int)blitOffset, (float)0.0f, (float)186.0f, (int)102, (int)5, (int)256, (int)512);
        if (this.trader != null && this.trader.isRegularVillager) {
            xp = this.trader.villagerExp;
            level = this.trader.getVillagerLevelFromExp();
        } else {
            xp = 0;
            level = 1;
        }
        if (xp > 250) {
            xp = 250;
        }
        switch (level) {
            case 1: {
                nextAt = 10;
                break;
            }
            case 2: {
                nextAt = 70;
                break;
            }
            case 3: {
                nextAt = 150;
                break;
            }
            default: {
                nextAt = 0;
            }
        }
        int width = (int)(100.0f * (float)xp / 250.0f);
        int nextWidth = nextAt > 0 ? (int)(100.0f * (float)nextAt / 250.0f) : 0;
        TraderScreen.blit((int)(++xpBarPosX), (int)(++xpBarPosY), (int)blitOffset, (float)1.0f, (float)192.0f, (int)width, (int)3, (int)256, (int)512);
        if (nextWidth > 0) {
            RenderSystem.enableBlend();
            TraderScreen.blit((int)(xpBarPosX + width), (int)xpBarPosY, (int)blitOffset, (float)((float)width + 103.0f), (float)192.0f, (int)(nextWidth - width), (int)3, (int)256, (int)512);
            RenderSystem.disableBlend();
        }
        if (this.trader != null) {
            MerchantOffers offers = this.trader.villagerOffers;
            this.drawScrollbar(offers);
            int offerCount = offers.size();
            int drawIndex = 0;
            int drawY = this.field_147009_r + 17;
            for (MerchantOffer merchantoffer : offers) {
                if (offerCount <= 7 || drawIndex >= this.topIndex && drawIndex < 7 + this.topIndex) {
                    ItemStack firstBuyItem = merchantoffer.func_222218_a();
                    ItemStack firstBuyItemDiscount = merchantoffer.func_222205_b();
                    ItemStack secondBuyItem = merchantoffer.func_222202_c();
                    ItemStack sellItem = merchantoffer.func_222200_d();
                    this.itemRenderer.field_77023_b = 100.0f;
                    int drawX = this.field_147003_i + 10;
                    int drawItemY = drawY + 2;
                    this.drawFirstItem(firstBuyItemDiscount, firstBuyItem, drawX, drawItemY);
                    if (!secondBuyItem.func_190926_b()) {
                        drawX = this.field_147003_i + 40;
                        this.itemRenderer.func_180450_b(secondBuyItem, drawX, drawItemY);
                        this.itemRenderer.func_175030_a(this.font, secondBuyItem, drawX, drawItemY);
                    }
                    this.drawNotAvaiable(merchantoffer, this.field_147003_i, drawItemY);
                    drawX = this.field_147003_i + 73;
                    this.itemRenderer.func_180450_b(sellItem, drawX, drawItemY);
                    this.itemRenderer.func_175030_a(this.font, sellItem, drawX, drawItemY);
                    this.itemRenderer.field_77023_b = 0.0f;
                    drawY += 20;
                }
                ++drawIndex;
            }
            for (TradeButton button : this.buttons) {
                if (button.isHovered()) {
                    button.renderToolTip(mouseX, mouseY);
                }
                button.visible = button.buttonIndex < offerCount;
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected class TradeButton
    extends Button {
        final int buttonIndex;

        public TradeButton(int posX, int posY, int index, Button.IPressable onPress) {
            super(posX, posY, 89, 20, "", onPress);
            this.buttonIndex = index;
            this.visible = false;
        }

        public boolean isHovered() {
            if (TraderScreen.this.selectedIndex - TraderScreen.this.topIndex == this.buttonIndex) {
                return true;
            }
            return super.isHovered();
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (TraderScreen.this.trader == null) {
                return;
            }
            MerchantOffers offers = ((TraderScreen)TraderScreen.this).trader.villagerOffers;
            int indexOnScreen = this.buttonIndex + TraderScreen.this.topIndex;
            if (!this.isHovered || offers.size() <= indexOnScreen) {
                return;
            }
            MerchantOffer offer = (MerchantOffer)offers.get(indexOnScreen);
            if (mouseX < this.x + 20) {
                ItemStack itemstack = offer.func_222205_b();
                TraderScreen.this.renderTooltip(itemstack, mouseX, mouseY);
            } else if (mouseX < this.x + 50 && mouseX > this.x + 30) {
                boolean preset;
                ItemStack itemstack2 = offer.func_222202_c();
                boolean bl = preset = !itemstack2.func_190926_b();
                if (preset) {
                    TraderScreen.this.renderTooltip(itemstack2, mouseX, mouseY);
                }
            } else if (mouseX > this.x + 65) {
                ItemStack itemstack1 = offer.func_222200_d();
                TraderScreen.this.renderTooltip(itemstack1, mouseX, mouseY);
            }
        }
    }
}

