/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.client.render.tileentity;

import a1lic.cubicvillager.client.GlobalClientVar;
import a1lic.cubicvillager.tileentity.TraderTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class TraderTileEntityRenderer
extends TileEntityRenderer<TraderTileEntity> {
    private static World WORLD;
    private static VillagerEntity VILLAGER;
    private static WanderingTraderEntity WANDERING;
    private static final float[] cachedProjectionMatrix;
    private static final Quaternion PERSPECTIVE_ROTATE_Y;
    private static final Quaternion ORTHOGRAPHIC_ROTATE_X;
    private static final Quaternion ORTHOGRAPHIC_ROTATE_Z;

    public TraderTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doRender(VillagerInfo info, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ResourceLocation villagerResource;
        ModelRenderer villagerHead;
        VillagerModel vm;
        Minecraft mc = Minecraft.func_71410_x();
        assert (mc.field_71441_e != null && mc.field_71439_g != null);
        if (WORLD != mc.field_71441_e) {
            WORLD = mc.field_71441_e;
            VILLAGER = new VillagerEntity(EntityType.field_200756_av, (World)mc.field_71441_e);
            WANDERING = new WanderingTraderEntity(EntityType.field_220351_aK, (World)mc.field_71441_e);
        }
        EntityRendererManager rm = mc.func_175598_ae();
        if (info.isRegularVillager) {
            VillagerRenderer vr = (VillagerRenderer)rm.func_78713_a((Entity)VILLAGER);
            vm = (VillagerModel)vr.func_217764_d();
            villagerHead = vm.func_205072_a();
            villagerResource = vr.func_110775_a(VILLAGER);
        } else {
            WanderingTraderRenderer wtr = (WanderingTraderRenderer)rm.func_78713_a((Entity)WANDERING);
            vm = (VillagerModel)wtr.func_217764_d();
            villagerHead = vm.func_205072_a();
            villagerResource = wtr.func_110775_a(WANDERING);
        }
        if (info.isItem) {
            villagerHead.field_78795_f = (float)Math.PI;
            villagerHead.field_78796_g = 0.0f;
            villagerHead.field_78808_h = 0.0f;
        } else {
            villagerHead.field_78795_f = (float)Math.PI;
            villagerHead.field_78796_g = (float)Math.PI / 180 * info.dir.func_185119_l() * -1.0f;
            villagerHead.field_78808_h = 0.0f;
        }
        RenderType rt = RenderType.func_228644_e_((ResourceLocation)villagerResource);
        rt.func_228547_a_();
        IVertexBuilder vb = buffer.getBuffer(rt);
        matrix.func_227860_a_();
        if (info.isItem) {
            float[] fArray = cachedProjectionMatrix;
            synchronized (cachedProjectionMatrix) {
                GL11.glGetFloatv((int)2983, (float[])cachedProjectionMatrix);
                boolean isOrthographic = cachedProjectionMatrix[15] != 0.0f;
                // ** MonitorExit[var12_11] (shouldn't be in output)
                if (isOrthographic) {
                    matrix.func_227861_a_(0.5, 0.25, 0.5);
                    matrix.func_227863_a_(ORTHOGRAPHIC_ROTATE_X);
                    matrix.func_227863_a_(ORTHOGRAPHIC_ROTATE_Z);
                } else {
                    boolean spinning;
                    DimensionType dim = mc.field_71441_e.field_73011_w.func_186058_p();
                    Map<UUID, GlobalPos> typeList = GlobalClientVar.meetingPointMap.get(mc.field_71441_e);
                    if (typeList != null) {
                        Collection<GlobalPos> posList = typeList.values();
                        double currentX = mc.field_71439_g.func_226277_ct_();
                        double currentY = mc.field_71439_g.func_226278_cu_();
                        double currentZ = mc.field_71439_g.func_226281_cx_();
                        double nearest = Double.MAX_VALUE;
                        BlockPos nearestPos = null;
                        for (GlobalPos gpos : posList) {
                            if (gpos.func_218177_a() != dim) continue;
                            BlockPos pos = gpos.func_218180_b();
                            double offsetX = (double)pos.func_177958_n() - currentX;
                            double offsetY = (double)pos.func_177956_o() - currentY;
                            double offsetZ = (double)pos.func_177952_p() - currentZ;
                            double dist = Math.sqrt(Math.pow(offsetX, 2.0) + Math.pow(offsetY, 2.0) + Math.pow(offsetZ, 2.0));
                            if (!(dist < nearest)) continue;
                            nearest = dist;
                            nearestPos = pos;
                        }
                        if (nearestPos != null) {
                            double offsetX = (double)nearestPos.func_177958_n() - currentX;
                            double offsetZ = (double)nearestPos.func_177952_p() - currentZ;
                            villagerHead.field_78796_g = (float)Math.atan2(offsetX, offsetZ);
                            float yaw = (float)((int)mc.field_71439_g.field_70177_z % 360) * ((float)Math.PI / 180) - 0.7853982f;
                            villagerHead.field_78796_g += yaw;
                            spinning = false;
                        } else {
                            spinning = true;
                        }
                    } else {
                        spinning = true;
                    }
                    if (spinning) {
                        villagerHead.field_78796_g = (float)(mc.field_71441_e.func_82737_E() % 100L) / 50.0f * (float)Math.PI;
                    }
                    matrix.func_227861_a_(0.5, 0.5, 0.5);
                    matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
                    matrix.func_227863_a_(PERSPECTIVE_ROTATE_Y);
                }
            }
        } else {
            matrix.func_227861_a_(0.5, 0.0, 0.5);
            matrix.func_227862_a_(1.6f, 1.6f, 1.6f);
        }
        {
            villagerHead.func_228309_a_(matrix, vb, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!info.isRegularVillager || info.profession == VillagerProfession.field_221151_a) {
                matrix.func_227865_b_();
                rt.func_228549_b_();
                return;
            }
            ResourceLocation prof = info.profession.getRegistryName();
            assert (prof != null);
            prof = new ResourceLocation(prof.func_110624_b(), String.format("textures/entity/villager/profession/%s.png", prof.func_110623_a()));
            ResourceLocation type = new ResourceLocation(prof.func_110624_b(), String.format("textures/entity/villager/type/%s.png", info.type.toString()));
            IVertexBuilder iv = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)type));
            villagerHead.func_228309_a_(matrix, iv, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            iv = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)prof));
            villagerHead.func_228309_a_(matrix, iv, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.func_227865_b_();
            rt.func_228549_b_();
            return;
        }
    }

    public static TileEntityRenderer<TraderTileEntity> factory(TileEntityRendererDispatcher dispatcher) {
        return new TraderTileEntityRenderer(dispatcher);
    }

    public boolean isGlobalRenderer(TraderTileEntity trader) {
        return false;
    }

    public void render(TraderTileEntity trader, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        TraderTileEntityRenderer.doRender(new VillagerInfo(trader), matrix, buffer, combinedLightIn, combinedOverlayIn);
    }

    static {
        cachedProjectionMatrix = new float[16];
        PERSPECTIVE_ROTATE_Y = new Quaternion(0.0f, 0.92387956f, 0.0f, -0.3826834f);
        ORTHOGRAPHIC_ROTATE_X = new Quaternion(0.25881904f, 0.0f, 0.0f, 0.9659258f);
        ORTHOGRAPHIC_ROTATE_Z = new Quaternion(0.0f, 0.38268346f, 0.0f, 0.9238795f);
    }

    public static class ISTER
    extends ItemStackTileEntityRenderer {
        public void func_228364_a_(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
            TraderTileEntityRenderer.doRender(new VillagerInfo(itemStackIn), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }

    private static class VillagerInfo {
        public final boolean isRegularVillager;
        public final VillagerProfession profession;
        public final IVillagerType type;
        public final boolean isItem;
        public final Direction dir;
        public final BlockPos pos;

        public VillagerInfo(ItemStack stack) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null) {
                this.isRegularVillager = tag.func_74767_n("Rglr");
                if (this.isRegularVillager) {
                    String _type = tag.func_74779_i("Type");
                    IVillagerType type = (IVillagerType)Registry.field_218369_K.func_82594_a(new ResourceLocation(_type));
                    String _prof = tag.func_74779_i("Prof");
                    VillagerProfession profession = (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(new ResourceLocation(_prof));
                    this.profession = profession == null ? VillagerProfession.field_221151_a : profession;
                    this.type = type;
                } else {
                    this.profession = VillagerProfession.field_221151_a;
                    this.type = IVillagerType.field_221175_c;
                }
            } else {
                this.isRegularVillager = true;
                this.profession = VillagerProfession.field_221151_a;
                this.type = IVillagerType.field_221175_c;
            }
            this.isItem = true;
            this.dir = Direction.NORTH;
            this.pos = null;
        }

        public VillagerInfo(TraderTileEntity trader) {
            this.isRegularVillager = trader.isRegularVillager;
            if (trader.isRegularVillager) {
                this.profession = trader.villagerProfession;
                this.type = trader.villagerType;
            } else {
                this.profession = VillagerProfession.field_221151_a;
                this.type = IVillagerType.field_221175_c;
            }
            this.isItem = false;
            this.dir = (Direction)trader.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J);
            this.pos = trader.func_174877_v();
        }
    }
}

