/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.event;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    @SubscribeEvent
    public static void loadConfigurations(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        LOGGER.info("load config from {}", (Object)config.getFileName());
    }

    @SubscribeEvent
    public static void reloadConfigurations(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        LOGGER.info("reload config from {}", (Object)config.getFileName());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        Pair p = builder.configure(Common::new);
        COMMON = (Common)p.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)p.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<String> testConfigString;
        public final ForgeConfigSpec.DoubleValue rangedValue;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Test Configuration Comment!");
            builder.translation("block.cubicvillager.cubic_villager");
            this.testConfigString = builder.define("TestConfigString", (Object)"Default...");
            builder.comment("Ranged Configuration!");
            builder.translation("item.cubicvillager.villager_wand");
            this.rangedValue = builder.defineInRange("RangedValue", Math.PI, -10.0, 10.0);
        }
    }
}

