/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.event;

import a1lic.cubicvillager.network.MeetingPointMessage;
import a1lic.cubicvillager.tool.network.PacketTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public final class LivingEntityHandler {
    public static final Map<ServerPlayerEntity, Map<UUID, GlobalPos>> SENT_MEETING_POINT_MAP = new WeakHashMap<ServerPlayerEntity, Map<UUID, GlobalPos>>();

    @SubscribeEvent
    public static void onVillagerTick(LivingEvent.LivingUpdateEvent event) {
        GlobalPos pos;
        Entity _e = event.getEntity();
        if (!(_e instanceof VillagerEntity) || !(_e.field_70170_p instanceof ServerWorld)) {
            return;
        }
        VillagerEntity villager = (VillagerEntity)_e;
        Brain brain = villager.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_220943_d)) {
            pos = null;
        } else {
            Optional _pos = brain.func_218207_c(MemoryModuleType.field_220943_d);
            assert (_pos.isPresent());
            pos = (GlobalPos)_pos.get();
        }
        List players = ((ServerWorld)villager.field_70170_p).func_217369_A();
        for (ServerPlayerEntity player : players) {
            UUID id;
            Map map = SENT_MEETING_POINT_MAP.computeIfAbsent(player, key -> new HashMap());
            GlobalPos posSent = (GlobalPos)map.get(id = villager.func_110124_au());
            if (posSent != null && posSent.equals((Object)pos)) continue;
            if (pos == null) {
                pos = (GlobalPos)map.get(id);
                map.remove(id);
            } else {
                map.put(id, pos);
            }
            PacketDistributor.PacketTarget tgt = PacketDistributor.PLAYER.with(() -> player);
            if (pos == null) {
                PacketTool.CHANNEL.send(tgt, (Object)new MeetingPointMessage(id, null, true));
                continue;
            }
            PacketTool.CHANNEL.send(tgt, (Object)new MeetingPointMessage(id, pos, false));
        }
    }
}

