/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.item;

import a1lic.cubicvillager.block.IBlockItem;
import a1lic.cubicvillager.event.RegistryHandler;
import a1lic.cubicvillager.tileentity.TraderTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class VillagerWand
extends Item {
    private static final String REGNAME = "villager_wand";
    private static final ResourceLocation RESLOC = new ResourceLocation("cubicvillager", "villager_wand");
    private static final Item.Properties PROPERTY = new Item.Properties();

    public VillagerWand() {
        super(PROPERTY);
        this.setRegistryName(RESLOC);
    }

    private static void dropGolemBlock(IronGolemEntity entity) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        ItemStack ironBlocks = new ItemStack((IItemProvider)Blocks.field_150339_S, 3);
        ItemStack pumpkin = new ItemStack((IItemProvider)Blocks.field_196625_cS, 1);
        ItemEntity drop = new ItemEntity(entity.field_70170_p, x, y, z, ironBlocks);
        entity.field_70170_p.func_217376_c((Entity)drop);
        drop = new ItemEntity(entity.field_70170_p, x, y, z, pumpkin);
        entity.field_70170_p.func_217376_c((Entity)drop);
    }

    private static void dropVillagerBlock(AbstractVillagerEntity entity) {
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        TraderTileEntity trader = new TraderTileEntity(entity);
        CompoundNBT tag = new CompoundNBT();
        trader.writeMetadatas(tag, true);
        BlockItem blk = ((IBlockItem)RegistryHandler.blockTrader).getBlockItem();
        ItemStack dropStack = new ItemStack((IItemProvider)blk);
        dropStack.func_77982_d(tag);
        ItemEntity drop = new ItemEntity(entity.field_70170_p, x, y, z, dropStack);
        entity.field_70170_p.func_217376_c((Entity)drop);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        Block block = state.func_177230_c();
        if (block != RegistryHandler.blockTrader) {
            return ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TraderTileEntity)) {
            return ActionResultType.PASS;
        }
        if (world instanceof ServerWorld) {
            PlayerEntity player = context.func_195999_j();
            if (player == null) {
                Block.func_220059_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)te);
            } else {
                Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)te, (Entity)player, (ItemStack)stack);
            }
            world.func_175655_b(pos, false);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!(entity instanceof AbstractVillagerEntity) && !(entity instanceof IronGolemEntity)) {
            return false;
        }
        double x = entity.func_226277_ct_();
        double y = entity.func_226278_cu_();
        double z = entity.func_226281_cx_();
        Random rng = ((LivingEntity)entity).func_70681_au();
        if (entity.field_70170_p instanceof ServerWorld) {
            if (entity instanceof AbstractVillagerEntity) {
                VillagerWand.dropVillagerBlock((AbstractVillagerEntity)entity);
            } else {
                VillagerWand.dropGolemBlock((IronGolemEntity)entity);
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                double xRnd = entity.func_226282_d_(1.0);
                double yRnd = entity.func_226279_cv_();
                double zRnd = entity.func_226287_g_(1.0);
                double xVec = rng.nextGaussian() * 0.02;
                double yVec = rng.nextGaussian() * 0.02;
                double zVec = rng.nextGaussian() * 0.02;
                entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, xRnd, yRnd, zRnd, xVec, yVec, zVec);
            }
        }
        float pitch = 0.8f + rng.nextFloat() * 0.4f;
        entity.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187924_gx, SoundCategory.NEUTRAL, 1.0f, pitch);
        ((LivingEntity)entity).func_70645_a(DamageSource.field_76376_m);
        entity.func_70106_y();
        return true;
    }

    static {
        PROPERTY.func_200917_a(1);
        PROPERTY.func_200916_a(RegistryHandler.CREATIVE_TAB);
        PROPERTY.setNoRepair();
    }
}

