/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.network;

import a1lic.cubicvillager.client.GlobalClientVar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MeetingPointMessage {
    private static final BlockPos DUMMY = new BlockPos(0, 0, 0);
    private UUID villager;
    private int dim;
    private BlockPos position;
    private boolean remove;

    public MeetingPointMessage() {
    }

    public MeetingPointMessage(UUID villager, GlobalPos pos, boolean remove) {
        this.villager = villager;
        this.dim = pos == null ? 0 : pos.func_218177_a().func_186068_a();
        this.position = pos == null ? DUMMY : pos.func_218180_b();
        this.remove = remove;
    }

    public MeetingPointMessage(PacketBuffer buf) {
        this.villager = buf.func_179253_g();
        this.dim = buf.readShort();
        this.position = buf.func_179259_c();
        this.remove = buf.readBoolean();
    }

    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.villager);
        buf.writeShort(this.dim);
        buf.func_179255_a(this.position);
        buf.writeBoolean(this.remove);
    }

    public void handle(Supplier<NetworkEvent.Context> sup) {
        NetworkEvent.Context ctx = sup.get();
        Minecraft mc = Minecraft.func_71410_x();
        Map meetingPointMap = GlobalClientVar.meetingPointMap.computeIfAbsent((World)mc.field_71441_e, key -> new HashMap());
        if (this.remove) {
            meetingPointMap.remove(this.villager);
        } else {
            DimensionType type = DimensionType.func_186069_a((int)this.dim);
            assert (type != null) : "INVALID DIMENSION ID";
            meetingPointMap.put(this.villager, GlobalPos.func_218179_a((DimensionType)type, (BlockPos)this.position));
        }
        ctx.setPacketHandled(true);
    }
}

